package main

import (
	"flag"
	"sdk_api/config"
	"sdk_api/dao"
	"sdk_api/server"
	"sdk_api/service"

	log "github.com/sirupsen/logrus"
)

func init() {
	log.SetFormatter(&log.TextFormatter{
		FullTimestamp: true,
	})
}

func main() {
	flag.Parse()
	cfg, err := config.New()
	if err != nil {
		panic(err)
	}

	da, err := dao.New(cfg)
	if err != nil {
		panic(err)
	}

	if cfg.Debug {
		log.SetLevel(log.DebugLevel)
	}

	svs := service.New(cfg, da)

	server.StartServer(svs, cfg)
}
