package config

import (
	"flag"

	"github.com/BurntSushi/toml"
	"github.com/ethereum/go-ethereum/common"
	"github.com/ethereum/go-ethereum/crypto"
)

type Config struct {
	Debug  bool         `toml:"debug"`
	MySQL  MysqlConfig  `toml:"mysql"`
	Server ServerConfig `toml:"server"`
	TGBot  TGBotConfig  `toml:"tg_bot"`
	Chain  ChainConfig  `toml:"chain"`
}

type MysqlConfig struct {
	Host        string `toml:"host"`
	Port        int    `toml:"port"`
	User        string `toml:"user"`
	Password    string `toml:"password"`
	Database    string `toml:"database"`
	MaxConn     int    `toml:"max_conn"`
	MaxIdleConn int    `toml:"max_idle_conn"`
}

type ServerConfig struct {
	Listen string `toml:"listen"`
}

type TGBotConfig struct {
	Tokens []string `toml:"tokens"`
}

type ChainConfig struct {
	SenderPrivateKey string `toml:"sender_private_key"`
	SenderAddress    string `toml:"sender_address"`

	UserContract string `toml:"user_contract"`
	RPC          string `toml:"rpc"`
}

var confPath = flag.String("c", "config.toml", "config file path")

func New() (config *Config, err error) {
	config = new(Config)
	_, err = toml.DecodeFile(*confPath, config)
	config.Chain.SenderAddress = crypto.PubkeyToAddress(crypto.ToECDSAUnsafe(common.FromHex(config.Chain.SenderPrivateKey)).PublicKey).Hex()
	return
}
