package db_model

import (
	"gorm.io/gorm"
)

type User struct {
	Id         int    `gorm:"primaryKey"`
	Uid        string `gorm:"type:varchar(255);uniqueIndex;not null;comment:用户id"`
	Platform   string `gorm:"type:varchar(255);uniqueIndex:platform_id;not null;comment:所在平台,telegram,fingerprint"`
	PlatformId string `gorm:"type:varchar(255);uniqueIndex:platform_id;not null;comment:所在平台id,telegram时id,指纹时hash"`
	Address    string `json:"type:varchar(255);index;comment:地址"`
	Keystore   string `gorm:"type:text;comment:keystore"`
	gorm.Model
}

type Task struct {
	Id        int    `gorm:"primaryKey"`
	TaskId    string `gorm:"type:varchar(255);uniqueIndex;not null;comment:任务id"`
	Uid       string `gorm:"type:varchar(255);index;not null;comment:用户id"`
	Action    string `gorm:"type:varchar(255);not null;comment:动作"`
	ToAddress string `gorm:"type:varchar(255);not null;comment:目标地址"`
	Value     string `gorm:"type:varchar(255);not null;comment:金额"`
	Calldata  string `gorm:"type:varchar(2048);not null;comment:参数"`
	TxHash    string `gorm:"type:varchar(255);index;not null;comment:交易hash"`
	TxStatus  int    `gorm:"type:int;not null;comment:交易状态"`
	gorm.Model
}
