package sender

import (
	"gopkg.in/gomail.v2"
)

var (
	smtpServer = "smtp.gmail.com"
	smtpPort   = 587
	username   string
	password   string
)

type EmailSender struct {
	Username string
	Password string
}

func NewEmailSender() *EmailSender {
	return &EmailSender{
		Username: username,
		Password: password,
	}
}

func (s *EmailSender) Send(dest string, code string) (err error) {
	m := gomail.NewMessage()
	m.SetHeader("From", s.Username)
	m.SetHeader("To", dest)
	m.SetHeader("Subject", "Test Email")
	m.SetBody("text/html", "<h1>Hello, this is a test email!</h1>")

	d := gomail.NewDialer(smtpServer, smtpPort, s.Username, s.Password)

	return d.DialAndSend(m)
}
