package server

import (
	"sdk_api/middleware"

	"github.com/gin-gonic/gin"
)

func initRouter(e *gin.Engine) {

	e.Use(middleware.PrintRequestResponseBodyMiddleware())
	v1 := e.Group("/api/v1")

	{
		user := v1.Group("/user")
		user.POST("/check", checkUser)
		user.POST("/serverLogin", login)
		user.POST("/create", middleware.JWTMiddleware, createUser)
	}
	{
		v1.GET("/task/status", getTaskStatus)
	}

}
