package server

import (
	"sdk_api/constant"

	"github.com/gin-gonic/gin"
)

func getTaskStatus(c *gin.Context) {
	taskId := c.Query("taskId")

	if taskId == "" {
		c.JSON(200, withError(constant.InvalidParam))
		return
	}

	status, err := srv.GetTaskStatus(taskId)
	if err != nil {
		c.JSON(200, withError(constant.InternalError))
		return
	}

	c.JSON(200, withSuccess(gin.H{
		"status": status,
	}))
}
