package util

import (
	"crypto/hmac"
	"crypto/sha256"
	"fmt"
	"net/url"
	"sort"
	"strconv"
	"strings"
	"time"

	"github.com/tidwall/gjson"
)

func VerifyInitData(initData, botToken string) (ok bool, botId, userId string) {
	h := hmac.New(sha256.New, []byte("WebAppData"))
	h.Write([]byte(botToken))
	secret := h.Sum(nil)
	h2 := hmac.New(sha256.New, secret)
	params, err := url.ParseQuery(initData)
	if err != nil {
		return
	}
	var hashval string
	var keys []string
	for key := range params {
		if key == "hash" {
			hashval = params.Get(key)
			continue
		}

		if key == "auth_date" {
			authDate, _ := strconv.Atoi(params.Get(key))
			if int64(authDate) < time.Now().Unix()-3600 || int64(authDate) > time.Now().Unix()+300 {
				// todo 可以限制超时时间
				return false, "", ""
			}
		}

		if key == "user" {
			userId = gjson.Get(params.Get(key), "id").String()
		}

		keys = append(keys, key)
	}

	sort.Strings(keys)
	var payloads []string
	for _, key := range keys {
		payloads = append(payloads, fmt.Sprintf("%s=%s", key, params.Get(key)))
	}
	payload := strings.Join(payloads, "\n")
	h2.Write([]byte(payload))
	h2sum := h2.Sum(nil)
	items := strings.Split(botToken, ":")
	if len(items) != 2 {
		return
	}
	ok = fmt.Sprintf("%x", h2sum) == hashval
	botId = items[0]
	return
}
