package db_model

import (
	"gorm.io/gorm"
)

type User struct {
	Id         int    `gorm:"primaryKey"`
	Uid        string `gorm:"type:varchar(255);uniqueIndex;not null;column:uid;comment:用户id"`
	Platform   string `gorm:"type:varchar(255);uniqueIndex:platform_id;not null;column:platform;comment:所在平台,telegram,fingerprint"`
	PlatformId string `gorm:"type:varchar(255);uniqueIndex:platform_id;not null;column:platform_id;comment:所在平台id,telegram时id,指纹时hash"`
	Address    string `json:"type:varchar(255);index;column:address;comment:地址"`
	Keystore   string `gorm:"type:text;column:keystore;comment:keystore"`
	gorm.Model
}
