package main

import (
	"flag"
	"io"
	"os"
	"sdk_api/config"
	"sdk_api/dao"
	exec "sdk_api/executor"

	log "github.com/sirupsen/logrus"
)

func initLog() {
	file, _ := os.OpenFile("log", os.O_CREATE|os.O_WRONLY|os.O_APPEND, 0666)
	mw := io.MultiWriter(os.Stdout, file)
	log.SetOutput(mw)
	log.SetFormatter(&log.TextFormatter{
		FullTimestamp: true,
	})
}

func main() {
	initLog()
	flag.Parse()

	cfg, err := config.New()
	if err != nil {
		panic(err)
	}

	da, err := dao.New(cfg)
	if err != nil {
		panic(err)
	}

	if cfg.Debug {
		log.SetLevel(log.DebugLevel)
	}

	tasker := exec.NewExecutor(cfg, da)
	tasker.Start()
	select {}
}
