package dao

import (
	"sdk_api/constant"
	dbModel "sdk_api/model/db"

	"gorm.io/gorm"
	"gorm.io/gorm/clause"
)

func (d *Dao) CreateUser(user *dbModel.User) (err error) {
	return d.db.Create(user).Error
}

func (d *Dao) CheckUser(platform string, platformId string) (user *dbModel.User, err error) {
	user = &dbModel.User{}
	err = d.db.Model(user).
		Where("platform = ? AND platform_id = ?", platform, platformId).
		First(user).
		Error
	if err == gorm.ErrRecordNotFound {
		return nil, nil
	}
	return
}

func (d *Dao) GetUserByUid(uid string) (user *dbModel.User, err error) {
	user = &dbModel.User{}
	err = d.db.Model(user).
		Where("uid = ?", uid).
		First(user).
		Error
	if err == gorm.ErrRecordNotFound {
		return nil, err
	}
	return
}

func (d *Dao) CreateEmptyUser(user *dbModel.User) (err error) {
	return d.db.Clauses(clause.OnConflict{DoNothing: true}).Create(user).Error
}

func (d *Dao) SetKeystore(uid, address, keystore string) (err error) {
	// set keystore only not exist
	return d.db.Model(&dbModel.User{}).
		Where("uid = ? AND keystore = ?", uid, "").
		// Update("keystore", keystore).
		Updates(map[string]interface{}{"keystore": keystore, "address": address}).
		Error
}

func (d *Dao) CreateTask(task *dbModel.Task) (err error) {
	return d.db.Clauses(clause.OnConflict{DoNothing: true}).Create(task).Error
}

func (d *Dao) UpdateTaskStatus(taskId, txHash string, status int) (err error) {
	if taskId != "" {
		return d.db.Model(&dbModel.Task{}).Where("task_id = ?", taskId).Updates(map[string]interface{}{
			"tx_hash":   txHash,
			"tx_status": status,
		}).Error
	}
	return d.db.Model(&dbModel.Task{}).Where("tx_hash = ?", txHash).Updates(map[string]interface{}{
		"tx_status": status,
	}).Error

}

func (d *Dao) GetTxHashesByStatus(status int) (txHashes []string, err error) {
	err = d.db.Model(&dbModel.Task{}).Select("tx_hash").Where("tx_status = ?", status).Limit(10).Scan(&txHashes).Error
	if err != nil {
		return
	}
	return
}

func (d *Dao) GetNotExecutedTasks() (tasks []*dbModel.Task, err error) {
	err = d.db.Model(&dbModel.Task{}).
		Where("tx_status = ?", constant.TransactionNotExecuted).
		Limit(10).
		Find(&tasks).Error
	return
}

func (d *Dao) GetTaskStatus(taskId string) (status int, err error) {
	err = d.db.Model(&dbModel.Task{}).Select("tx_status").Where("task_id = ?", taskId).First(&status).Error
	if err == gorm.ErrRecordNotFound {
		return -1, nil
	}
	return
}
