package server

import (
	"kv_api/middleware"

	"github.com/gin-gonic/gin"
)


func initRouter(e *gin.Engine)  {
	e.Use(
		middleware.PrintRequestResponseBodyMiddleware(),
		middleware.JWTMiddleware,
		)

	v1 := e.Group("/kvapi/v1")

	{
		user := v1.Group("/storage")
		user.GET("/get", get)
		user.POST("/set", set)
		user.POST("/del", del)
	}


}
