package server

import (
	"kv_api/config"
	"kv_api/dao"

	"github.com/gin-contrib/cors"
	"github.com/gin-gonic/gin"
	log "github.com/sirupsen/logrus"
)

var d *dao.Dao
var conf *config.Config

func StartServer(_dao *dao.Dao, _conf *config.Config) {
	d = _dao
	conf = _conf
	if !conf.Debug {
		gin.SetMode(gin.ReleaseMode)
	}
	engine := gin.Default()

	_cors := cors.DefaultConfig()
	_cors.AllowAllOrigins = true
	_cors.AllowHeaders = []string{"*"}

	engine.Use(cors.New(_cors))

	initRouter(engine)
	log.Infof("start http server listening %s", conf.Server.Listen)
	if err := engine.Run(conf.Server.Listen); err != nil {
		log.Error("http server run error: ", err)
	}
}
