package constant

import (
	"math/big"
)

const JwtSecret = "VrA1tFnHBhNTPRriHdUQLuFHb4PAFPAa"

const (
	InvalidParam  = "invalid param"
	InternalError = "internal error"
)

var (
	ZeroValue = big.NewInt(0)
	Gwei      = big.NewInt(1000000000)
	Ether     = big.NewInt(1000000000000000000)
)

const (
	TaskPlatformApp      = "app"
	TaskPlatformTwitter  = "twitter"
	TaskPlatformTelegram = "telegram"
	TaskPlatformAppbase  = "appbase"
	TaskPlatformWeb      = "web"
)

var validPlatforms = map[string]bool{
	TaskPlatformApp:      true,
	TaskPlatformTwitter:  true,
	TaskPlatformTelegram: true,
	TaskPlatformAppbase:  true,
	TaskPlatformWeb:      true,
}

func IsValidPlatform(platform string) bool {
	_, ok := validPlatforms[platform]
	return ok
}

const (
	TaskActionBind          = "bind"
	TaskActionJoin          = "join"
	TaskActionActive        = "active"
	TaskActionFollow        = "follow"
	TaskActionLike          = "like"
	TaskActionReply         = "reply"
	TaskActionRetweet       = "retweet"
	TaskActionInvite        = "invite"
	TaskActionSignIn        = "signIn"
	TaskActionPremiumSignIn = "premiumSignIn"
	TaskActionMiniapp       = "minapp"
	TaskActionWeb           = "web"
)

var validActions = map[string]bool{
	TaskActionBind:          true,
	TaskActionJoin:          true,
	TaskActionActive:        true,
	TaskActionFollow:        true,
	TaskActionLike:          true,
	TaskActionReply:         true,
	TaskActionRetweet:       true,
	TaskActionInvite:        true,
	TaskActionSignIn:        true,
	TaskActionPremiumSignIn: true,
	TaskActionMiniapp:       true,
	TaskActionWeb:           true,
}

func IsValidAction(action string) bool {
	_, ok := validActions[action]
	return ok
}

var TaskAction = map[string][]string{
	TaskPlatformApp:      {TaskActionActive, TaskActionInvite},
	TaskPlatformTelegram: {TaskActionJoin, TaskActionActive, TaskActionBind, TaskActionMiniapp},
	TaskPlatformTwitter:  {TaskActionFollow, TaskActionLike, TaskActionReply, TaskActionRetweet},
	TaskPlatformAppbase:  {TaskActionSignIn, TaskActionPremiumSignIn},
	TaskPlatformWeb:      {TaskActionWeb},
}

const (
	TwitterAPIActionRetweet = "retweeters"
	TwitterAPIActionLike    = "tweet_liking_users"
	TwitterAPIActionFollow  = "followers"
)

const (
	TaskHistoryStatusPending     = "pending" // 点了检查，3分钟后检查
	TaskHistoryStatusSuccess     = "success" // 3分钟后检查成功
	TaskHistoryStatusRetry       = "retry"   // 3分钟后检查未完成
	TaskHistoryStatusUncompleted = "uncompleted"
	TaskHistoryStatusTodo        = "todo"
)
