package middleware

import (
	"taskcenter/constant"
	"taskcenter/dao"
	"taskcenter/util"

	"github.com/gin-gonic/gin"
	log "github.com/sirupsen/logrus"
)

func JWTMiddleware(d *dao.Dao, secret string, needAdmin bool) gin.HandlerFunc {
	return func(c *gin.Context) {
		tokenString := c.GetHeader("Authorization")
		if tokenString == "" || len(tokenString) < 7 {
			c.JSON(200, gin.H{
				"code": 1,
				"msg":  "invalid token",
				"data": "",
			})
			c.Abort()
			return
		}

		ok, expired, uid, _ := util.ParseJWT(secret, tokenString[7:])
		if !ok {
			c.JSON(200, gin.H{
				"code": 1,
				"msg":  "invalid token",
				"data": "",
			})
			c.Abort()
			return
		}

		if expired {
			c.JSON(200, gin.H{
				"code": 1,
				"msg":  "token expired",
				"data": "",
			})
			c.Abort()
			return
		}

		ok, err := d.IsAdminUser(uid)
		if err != nil {
			log.WithError(err).Error("auth is admin")
			c.JSON(200, gin.H{
				"code": 1,
				"msg":  constant.InternalError,
				"data": "",
			})
			c.Abort()
			return
		}
		if needAdmin {
			if !ok {
				c.JSON(200, gin.H{
					"code": 1,
					"msg":  "no access permissions",
					"data": "",
				})
				c.Abort()
				return
			}
		}

		log.WithField("userId", uid).Debug("jwt uid")
		c.Set("userId", uid)
		c.Set("admin", ok)
		c.Next()
	}
}
