package util

import (
	"time"

	"github.com/golang-jwt/jwt/v5"
)

func ParseJWT(secret, token string) (ok, expired bool, uid string) {
	claims := jwt.MapClaims{}
	tk, err := jwt.ParseWithClaims(token, claims, func(t *jwt.Token) (interface{}, error) {
		return []byte(secret), nil
	})
	if err != nil {
		return
	}

	if !tk.Valid {
		return
	}

	exp, _ := claims.GetExpirationTime()
	if exp == nil || exp.Before(time.Now()) {
		expired = true
		return
	}

	if claims["is_anonymous"].(bool) {
		// return
	}

	uid = claims["sub"].(string)
	if uid == "" {
		return
	}
	ok = true
	return

}
