package api_model

type CreateProjectRequest struct {
	ProjectName string `json:"projectName"  binding:"required"`
	Description string `json:"description" binding:"required"`
}

type GetProjectResponse struct {
	ProjectName    string `json:"projectName"`
	TelegramChatId int    `json:"telegramChatId"`
	TwitterHandle  string `json:"twitterHandle"`
}

type CreateGroupRequest struct {
	ProjectId   int    `json:"projectId"  binding:"required"`
	Description string `json:"description"`
	Tasks       []Task `json:"tasks"`
}

type Task struct {
	TaskId         int    `json:"taskId,omitempty"`
	Platform       string `json:"platform"  binding:"required"`
	Action         string `json:"action"  binding:"required"`
	Url            string `json:"url"   binding:"required"`
	TwitterUserId  int    `json:"twitterUserId"`
	TelegramChatId int    `json:"telegramChatId"`
	TweetId        int    `json:"tweetId"`
	Description    string `json:"description"  binding:"required"`
	Reward         int    `json:"reward" binding:"required"`
	Start          int    `json:"start" binding:"required"`
	End            int    `json:"end" binding:"required"`
	Daily          bool   `json:"daily" binding:"required"`
}

type GetGroupResponse CreateGroupRequest
