package service

import (
	apiModel "sdk_api/model/api"
	dbModel "sdk_api/model/db"
	"sdk_api/util"

	log "github.com/sirupsen/logrus"
)

func (s *Service) CreateProject(req *apiModel.CreateProjectRequest) (resp *apiModel.CreateProjectResponse, err error) {
	resp = &apiModel.CreateProjectResponse{}
	twitterUserId, twitterHandle, twitterName, err := s.d.CreateTwitterProject(req.TwitterAPIKey, req.TwitterAPISecret, req.TwitterAccessToken, req.TwitterAccessSecret, req.TwitterToken, req.ProjectName)
	if err != nil {
		log.WithError(err).Error("create twitter project error")
		return
	}

	tgTitle, tgUsername, err := s.d.GetTGGroupInfo(req.TelegramChatId)
	if err != nil {
		log.WithError(err).Error("get telegram group info error")
		return
	}

	p := &dbModel.Project{
		Id:                   util.GenFlakeID(),
		Name:                 req.ProjectName,
		Description:          req.Description,
		TwitterAPIKey:        req.TwitterAPIKey,
		TwitterAPISecret:     req.TwitterAPISecret,
		TwitterAccessToken:   req.TwitterAccessToken,
		TwitterAccessSecret:  req.TwitterAccessSecret,
		TwitterToken:         req.TwitterToken,
		TwitterHandle:        twitterHandle,
		TwitterName:          twitterName,
		TwitterUserId:        twitterUserId,
		TelegramChatId:       req.TelegramChatId,
		TelegramChatTitle:    tgTitle,
		TelegramChatUsername: tgUsername,
	}
	err = s.d.CreateProject(p)
	if err != nil {
		log.WithError(err).Error("create project error")
		return
	}

	resp.TelegramChatUsername = tgUsername
	resp.TelegramChatTitle = tgTitle
	resp.TwitterName = twitterName
	resp.TwitterHandle = twitterHandle
	resp.ProjectId = p.Id
	return
}

func (s *Service) GetProjectList(page, pageSize int) (resp *apiModel.GetProjectListResponse, err error) {
	resp = &apiModel.GetProjectListResponse{}
	list, count, err := s.d.GetProjectList(page, pageSize)
	if err != nil {
		log.WithError(err).Error("get project list error")
		return
	}
	resp.TotalCount = count
	resp.Items = make([]*apiModel.GetProjectResponse, 0)
	for _, v := range list {
		resp.Items = append(resp.Items, &apiModel.GetProjectResponse{
			ProjectId:            v.Id,
			TelegramChatId:       v.TelegramChatId,
			TwitterHandle:        v.TwitterHandle,
			TwitterName:          v.TwitterName,
			TwitterUserId:        v.TwitterUserId,
			Description:          v.Description,
			TelegramChatTitle:    v.TelegramChatTitle,
			TelegramChatUsername: v.TelegramChatUsername,
			ProjectName:          v.Name,
		})
	}
	return
}

func (s *Service) GetProject(pid int) (resp *apiModel.GetProjectResponse, err error) {
	p, err := s.d.GetProject(pid)
	if err != nil {
		log.WithError(err).Error("get project error")
		return
	}
	if p == nil {
		log.WithError(err).Error("project not found")
		return nil, nil
	}

	return &apiModel.GetProjectResponse{
		TelegramChatId:       p.TelegramChatId,
		TelegramChatUsername: p.TelegramChatUsername,
		TelegramChatTitle:    p.TelegramChatTitle,
		TwitterHandle:        p.TwitterHandle,
		TwitterName:          p.TwitterName,
		TwitterUserId:        p.TwitterUserId,
		ProjectName:          p.Name,
		Description:          p.Description,
		// TwitterAPIKey:       p.TwitterAPIKey,
		// TwitterAPISecret:    p.TwitterAPISecret,
		// TwitterAccessToken:  p.TwitterAccessToken,
		// TwitterAccessSecret: p.TwitterAccessSecret,
		// TwitterToken:        p.TwitterToken,
	}, nil
}
