package api_model

type CreateProjectRequest struct {
	ProjectName         string `json:"projectName"  binding:"required"`
	Description         string `json:"description"`
	TwitterAPIKey       string `json:"twitterAPIKey" binding:"required"`
	TwitterAPISecret    string `json:"twitterAPISecret" binding:"required"`
	TwitterAccessToken  string `json:"twitterAccessToken" binding:"required"`
	TwitterAccessSecret string `json:"twitterAccessSecret" binding:"required"`
	TwitterToken        string `json:"twitterToken" binding:"required"`
	TelegramChatId      int    `json:"telegramChatId" binding:"required"`
	UserId              string `json:"-"`
}

type CreateProjectResponse struct {
	ProjectId            int    `json:"projectId"`
	TwitterHandle        string `json:"twitterHandle"`
	TwitterName          string `json:"twitterName"`
	TelegramChatTitle    string `json:"telegramChatTitle"`
	TelegramChatUsername string `json:"telegramChatUsername"`
}

type GetProjectResponse struct {
	ProjectId            int    `json:"projectId,omitempty"`
	TelegramChatId       int    `json:"telegramChatId"`
	TelegramChatUsername string `json:"telegramChatUsername"`
	TelegramChatTitle    string `json:"telegramChatTitle"`
	TwitterHandle        string `json:"twitterHandle"`
	TwitterName          string `json:"twitterName"`
	TwitterUserId        int    `json:"twitterUserId"`
	ProjectName          string `json:"projectName"`
	Description          string `json:"description"`
	TwitterAPIKey        string `json:"twitterAPIKey,omitempty"`
	TwitterAPISecret     string `json:"twitterAPISecret,omitempty"`
	TwitterAccessToken   string `json:"twitterAccessToken,omitempty"`
	TwitterAccessSecret  string `json:"twitterAccessSecret,omitempty"`
	TwitterToken         string `json:"twitterToken,omitempty"`
	UserId               string `json:"-"`
}

type CreateGroupRequest struct {
	ProjectId   int    `json:"projectId"  binding:"required"`
	GroupId     int    `json:"groupId,omitempty"`
	Description string `json:"description"`
	Tasks       []Task `json:"tasks"`
	UserId      string `json:"-"`
}

type Task struct {
	TaskId      int    `json:"taskId,omitempty"`
	Platform    string `json:"platform"  binding:"required"`
	Action      string `json:"action"  binding:"required"`
	Url         string `json:"url"`
	TweetId     int    `json:"tweetId"`
	Description string `json:"description"  binding:"required"`
	Reward      int    `json:"reward" binding:"required"`
	Start       int    `json:"start" binding:"required"`
	End         int    `json:"end" binding:"required"`
	Daily       bool   `json:"daily" binding:"required"`
	Status      string `json:"status"`
}

type GetGroupResponse CreateGroupRequest

type GetGroupListResponse struct {
	TotalCount int                 `json:"totalCount"`
	Items      []*GetGroupResponse `json:"items"`
}

type GetProjectListResponse struct {
	TotalCount int                   `json:"totalCount"`
	Items      []*GetProjectResponse `json:"items"`
}
