package server

import (
	"taskcenter/middleware"

	"github.com/gin-gonic/gin"
)

func initRouter(e *gin.Engine) {

	e.Use(middleware.PrintRequestResponseBodyMiddleware())
	v1 := e.Group("/api/v1")

	{
		project := v1.Group("/project", middleware.JWTMiddleware(conf.Supabase.JWTSecret, true))
		project.GET("/:pid", getProject)       // 获取项目详情
		project.GET("/list", listProject)      // 获取项目列表
		project.POST("/create", createProject) // 创建项目
	}

	{
		group := v1.Group("/group", middleware.JWTMiddleware(conf.Supabase.JWTSecret, false))
		group.GET("/:gid", getGroup)       // 获取任务组任务详情
		group.GET("/list", listGroup)      // 获取任务组任务详情
		group.POST("/create", createGroup) // 创建任务组
	}

	{
		task := v1.Group("/task", middleware.JWTMiddleware(conf.Supabase.JWTSecret, false))
		task.POST("/submit/:tid", submitTask) // 提交任务
		task.GET("/check/:tid", checkTask)    // 检查任务是否完成
	}

}
