package config

import (
	"flag"

	"github.com/BurntSushi/toml"
)

type Config struct {
	Debug       bool              `toml:"debug"`
	PGSQL       PGSQLConfig       `toml:"pgsql"`
	Server      ServerConfig      `toml:"server"`
	TGTask      TGTaskConfig      `toml:"tg_task"`
	TwitterTask TwitterTaskConfig `toml:"twitter_task"`
	Supabase    SupabaseConfig    `tomo:"supabase"`
}

type SupabaseConfig struct {
	AuthURL   string `toml:"auth_url"`
	APIKey    string `toml:"api_key"`
	JWTSecret string `toml:"jwt_secret"`
}

type PGSQLConfig struct {
	Host        string `toml:"host"`
	Port        int    `toml:"port"`
	User        string `toml:"user"`
	Password    string `toml:"password"`
	Database    string `toml:"database"`
	MaxConn     int    `toml:"max_conn"`
	MaxIdleConn int    `toml:"max_idle_conn"`
	EnableLog   bool   `toml:"enable_log"`
	CertFile    string `toml:"cert_file"`
}

type TGTaskConfig struct {
	URL      string `toml:"url"`
	BOTToken string `toml:"bot_token"`
}

type TwitterTaskConfig struct {
	URL        string `toml:"url"`
	PassFollow bool   `toml:"pass_follow"`
}

type ServerConfig struct {
	Listen string `toml:"listen"`
}

var confPath = flag.String("c", "config.toml", "config file path")

func New() (config *Config, err error) {
	config = new(Config)
	_, err = toml.DecodeFile(*confPath, config)
	return
}
