package server

import (
	"taskcenter/config"
	"taskcenter/dao"
	"taskcenter/service"

	"github.com/gin-contrib/cors"
	"github.com/gin-gonic/gin"
	log "github.com/sirupsen/logrus"
)

var srv *service.Service
var d *dao.Dao
var conf *config.Config

func StartServer(_srv *service.Service, _dao *dao.Dao, _conf *config.Config) {
	srv = _srv
	d = _dao
	conf = _conf
	if !conf.Debug {
		gin.SetMode(gin.ReleaseMode)
	}
	engine := gin.Default()

	_cors := cors.DefaultConfig()
	_cors.AllowAllOrigins = true
	_cors.AllowHeaders = []string{"*"}

	engine.Use(cors.New(_cors))

	initRouter(engine)
	log.Infof("start http server listening %s", conf.Server.Listen)
	if err := engine.Run(conf.Server.Listen); err != nil {
		log.Error("http server run error: ", err)
	}
}

func withSuccess(obj interface{}) interface{} {
	return gin.H{
		"code": 0,
		"msg":  "ok",
		"data": obj,
	}
}

func withError(msg string) interface{} {
	return gin.H{
		"code":  1,
		"error": msg,
		"data":  "",
	}
}
