package server

import (
	"strconv"
	"taskcenter/constant"
	apiModel "taskcenter/model/api"

	"github.com/gin-gonic/gin"
)

func createGroup(c *gin.Context) {
	req := &apiModel.CreateGroupRequest{}
	if err := c.ShouldBindJSON(req); err != nil {
		c.JSON(200, withError(constant.InvalidParam))
		return
	}
	req.UserId = c.GetString("userId")

	gid, err := srv.CreateGroup(req)
	if err != nil {
		c.JSON(200, withError(constant.InternalError))
		return
	}

	c.JSON(200, withSuccess(gin.H{"groupId": gid}))
}

func getGroup(c *gin.Context) {
	_gid := c.Param("gid")
	gid, _ := strconv.Atoi(_gid)
	if gid == 0 {
		c.JSON(200, withError(constant.InvalidParam))
		return
	}
	userId := c.GetString("userId")
	admin := c.GetBool("admin")
	resp, err := srv.GetGroup(gid, userId, admin)
	if err != nil {
		c.JSON(200, withError(constant.InternalError))
		return
	}
	c.JSON(200, withSuccess(resp))
}

func getGroupV2(c *gin.Context) {
	_gid := c.Param("gid")
	gid, _ := strconv.Atoi(_gid)
	if gid == 0 {
		c.JSON(200, withError(constant.InvalidParam))
		return
	}
	userId := c.GetString("userId")
	admin := c.GetBool("admin")
	resp, err := srv.GetGroup(gid, userId, admin)
	if err != nil {
		c.JSON(200, withError(constant.InternalError))
		return
	}

	for i := 0; i < len(resp.Tasks); i++ {
		resp.Tasks[i].TaskId = strconv.Itoa(resp.Tasks[i].TaskId.(int))
	}
	c.JSON(200, withSuccess(resp))
}


func listGroup(c *gin.Context) {
	_page := c.DefaultQuery("page", "1")
	_pageSize := c.DefaultQuery("pageSize", "10")
	page, _ := strconv.Atoi(_page)
	pageSize, _ := strconv.Atoi(_pageSize)

	if page < 1 || pageSize < 1 || pageSize > 100 {
		c.JSON(200, withError(constant.InvalidParam))
		return
	}
	admin := c.GetBool("admin")
	resp, err := srv.GetGroupList(page, pageSize, admin)
	if err != nil {
		c.JSON(200, withError(constant.InternalError))
		return
	}
	c.JSON(200, withSuccess(resp))
}
