package db_model

import (
	"time"

	"gorm.io/datatypes"
)

type Identity struct {
	Id           string         `gorm:"primaryKey;type:uuid;not null;comment:用户id"`
	ProviderId   string         `gorm:"type:text;not null;comment:第三方用户id"`
	UserId       string         `gorm:"type:uuid;not null;comment:用户id"`
	IdentityData datatypes.JSON `gorm:"type:json;not null;comment:用户身份数据"`
	Provider     string         `gorm:"type:text;not null;comment:第三方用户平台"`
	LastSignInAt time.Time      `gorm:"type:timestamp;not null;comment:最后登录时间"`
	Email        string         `gorm:"type:text;not null;comment:用户邮箱"`
	CreatedAt    time.Time
	UpdatedAt    time.Time
}

func (*Identity) TableName() string {
	return "auth.identities"
}

func (*Identity) TelegramAuthTableName() string {
	// return "telegram.identities"
	return "public.identities"
}
