package db_model

import (
	"database/sql"
	"time"

	"gorm.io/gorm"
)

type TaskAction struct {
	Id       int    `gorm:"primaryKey;autoIncrement:false"`
	Platform string `gorm:"type:text;uniqueIndex:uidx_platform_action;not null;comment:任务平台"`
	Action   string `gorm:"type:text;uniqueIndex:uidx_platform_action;not null;comment:任务动作"`
	gorm.Model
}

func (t *TaskAction) TableName() string {
	return "taskcenter.task_action"
}

type Project struct {
	Id                   int    `gorm:"primaryKey;autoIncrement:false"`
	UserId               string `gorm:"type:uuid;not null;comment:关联用户id"`
	Name                 string `gorm:"type:text;not null;comment:项目名称"`
	Description          string `gorm:"type:text;not null;comment:项目描述"`
	TwitterAPIKey        string `gorm:"type:text;not null;comment:tweet api key"`
	TwitterAPISecret     string `gorm:"type:text;not null;comment:tweet api secret"`
	TwitterAccessToken   string `gorm:"type:text;not null;comment:tweet access token"`
	TwitterAccessSecret  string `gorm:"type:text;not null;comment:tweet access secret"`
	TwitterToken         string `gorm:"type:text;not null;comment:tweet token"`
	TwitterHandle        string `gorm:"type:text;not null;comment:tweet handle"`
	TwitterName          string `gorm:"type:text;not null;comment:tweet name"`
	TwitterUserId        int    `gorm:"type:int;not null;comment:tweet user id"`
	TelegramChatId       int    `gorm:"type:int;not null;comment:telegram chat id"`
	TelegramChatUsername string `gorm:"type:text;not null;comment:telegram chat username"`
	TelegramChatTitle    string `gorm:"type:text;not null;comment:telegram chat title"`
	gorm.Model

	Groups []*TaskGroup
}

func (p *Project) TableName() string {
	return "taskcenter.project"
}

type TaskGroup struct {
	Id          int    `gorm:"primaryKey;autoIncrement:false"`
	UserId      string `gorm:"type:uuid;not null;comment:关联用户id"`
	Description string `gorm:"type:text;not null;comment:任务组描述"`
	gorm.Model
}

func (t *TaskGroup) TableName() string {
	return "taskcenter.task_group"
}

type Config struct {
	TwitterAPIKey        string `gorm:"type:text;not null;comment:tweet api key"`
	TwitterAPISecret     string `gorm:"type:text;not null;comment:tweet api secret"`
	TwitterAccessToken   string `gorm:"type:text;not null;comment:tweet access token"`
	TwitterAccessSecret  string `gorm:"type:text;not null;comment:tweet access secret"`
	TwitterToken         string `gorm:"type:text;not null;comment:tweet token"`
	TwitterHandle        string `gorm:"type:text;not null;comment:tweet handle"`
	TwitterName          string `gorm:"type:text;not null;comment:tweet name"`
	TwitterUserId        int    `gorm:"type:int;not null;comment:tweet user id，用于关注"`
	TelegramChatId       int    `gorm:"type:int;not null;comment:telegram chat id"`
	TelegramChatUsername string `gorm:"type:text;not null;comment:telegram chat username"`
	TelegramChatTitle    string `gorm:"type:text;not null;comment:telegram chat title"`
}

type Task struct {
	Id                      int          `gorm:"primaryKey;autoIncrement:false"`
	GroupId                 int          `gorm:"type:int;index;not null;comment:任务组id"`
	Platform                string       `gorm:"type:text;not null;comment:任务平台"`
	Action                  string       `gorm:"type:text;not null;comment:任务动作"`
	Url                     string       `gorm:"type:text;not null;comment:任务链接"`
	TweetId                 int          `gorm:"type:int;not null;comment:推文id，用于转发点赞"`
	Description             string       `gorm:"type:text;not null;comment:任务描述"`
	Reward                  int          `gorm:"type:int;not null;comment:任务奖励"`
	Start                   int          `gorm:"type:int;not null;comment:任务开始时间"`
	End                     int          `gorm:"type:int;index;not null;comment:任务结束时间"`
	Daily                   bool         `gorm:"type:bool;not null;comment:是否是每日任务"`
	TwitterTaskEndAt        sql.NullTime `gorm:"index;comment:推特可用，推特任务中心已停止"`
	TelegramActiveThreshold int          `gorm:"type:int;not null;comment:telegram群活跃阈值"`
	Enable                  bool         `gorm:"type:bool;not null;comment:是否启用"`
	Config
	gorm.Model
}

func (t *Task) TableName() string {
	return "taskcenter.task"
}

type TaskHistory struct {
	Id           int       `gorm:"primaryKey;autoIncrement:false"`
	TaskId       int       `gorm:"type:int;index;not null;comment:任务id"`
	UserId       string    `gorm:"type:uuid;index;not null;comment:用户id"`
	RewardTxHash string    `gorm:"type:text;not null;index;comment:发放奖励的txHash"`
	Status       string    `gorm:"type:text;not null;comment:任务状态"`
	CreatedAt    time.Time `gorm:"index"`
	UpdatedAt    time.Time `gorm:"index"`
	gorm.Model
}

func (t *TaskHistory) TableName() string {
	return "taskcenter.task_history"
}

type AdminUser struct {
	Id     int    `gorm:"primaryKey;autoIncrement:true"`
	UserId string `gorm:"type:uuid;index;not null;comment:用户id"`
	gorm.Model
}

func (a *AdminUser) TableName() string {
	return "taskcenter.admin_user"
}
