package dao

import (
	dbModel "taskcenter/model/db"

	"gorm.io/gorm"
)

func (d *Dao) GetProviderId(userId, platform string) (providerId string, err error) {
	tx := d.db
	if platform == "telegram" {
		tx = d.db.Table((&dbModel.Identity{}).TelegramAuthTableName())
	} else {
		tx = d.db.Table((&dbModel.Identity{}).TableName())
	}

	err = tx.Select("provider_id").Where("user_id = ? and provider = ?", userId, platform).Take(&providerId).Error
	if err == gorm.ErrRecordNotFound {
		return "", nil
	}
	return providerId, err
}
