package server

import (
	"strconv"
	"taskcenter/constant"
	apiModel "taskcenter/model/api"

	"github.com/gin-gonic/gin"
)

func createGroup(c *gin.Context) {
	req := &apiModel.CreateGroupRequest{}
	if err := c.ShouldBindJSON(req); err != nil {
		c.JSON(200, withError(constant.InvalidParam))
		return
	}
	req.UserId = c.GetString("userId")

	if len(req.Tasks) == 0 {
		c.JSON(200, withError(constant.InvalidParam))
		return
	}

	project, err := srv.GetProject(req.ProjectId)
	if err != nil {
		c.JSON(200, withError(constant.InternalError))
		return
	}

	if project == nil {
		c.JSON(200, withError("project not found"))
		return
	}

	if project.UserId != req.UserId {
		c.JSON(200, withError("permission denied"))
		return
	}

	for _, task := range req.Tasks {
		if !constant.IsValidAction(task.Action) || !constant.IsValidPlatform(task.Platform) {
			c.JSON(200, withError(constant.InvalidParam))
			return
		}
		// go wait retry done
		// if task.Platform == constant.TaskPlatformTelegram && task.TelegramChatId == 0 {
		// 	c.JSON(200, withError(constant.InvalidParam))
		// 	return
		// }
		// if task.Platform == constant.TaskPlatformTwitter && task.TweetId == 0 && task.TwitterUserId == 0 {
		// 	c.JSON(200, withError(constant.InvalidParam))
		// 	return
		// }

		if task.Platform == constant.TaskPlatformTwitter && task.Action != constant.TaskActionFollow && task.TweetId == 0 {
			c.JSON(200, withError(constant.InvalidParam))
			return
		}
	}

	gid, err := srv.CreateGroup(req)
	if err != nil {
		c.JSON(200, withError(constant.InternalError))
		return
	}

	c.JSON(200, withSuccess(gin.H{"groupId": gid}))
}

func getGroup(c *gin.Context) {
	_gid := c.Param("gid")
	gid, _ := strconv.Atoi(_gid)
	if gid == 0 {
		c.JSON(200, withError(constant.InvalidParam))
		return
	}
	userId := c.GetString("userId")

	resp, err := srv.GetGroup(gid, userId)
	if err != nil {
		c.JSON(200, withError(constant.InternalError))
		return
	}
	c.JSON(200, withSuccess(resp))
}

func listGroup(c *gin.Context) {
	_page := c.DefaultQuery("page", "1")
	_pageSize := c.DefaultQuery("pageSize", "10")
	page, _ := strconv.Atoi(_page)
	pageSize, _ := strconv.Atoi(_pageSize)

	if page < 1 || pageSize < 1 || pageSize > 100 {
		c.JSON(200, withError(constant.InvalidParam))
		return
	}

	resp, err := srv.GetGroupList(page, pageSize)
	if err != nil {
		c.JSON(200, withError(constant.InternalError))
		return
	}
	c.JSON(200, withSuccess(resp))
}
