package server

import (
	"strconv"
	"taskcenter/constant"

	"github.com/gin-gonic/gin"
)

func checkTask(c *gin.Context) {
	_taskId := c.Param("tid")
	taskId, _ := strconv.Atoi(_taskId)
	// userId := c.Query("userId")
	userId := c.GetString("userId")

	if taskId == 0 || userId == "" {
		c.JSON(200, withError(constant.InvalidParam))
		return
	}

	status, err := srv.GetTaskResult(taskId, userId)
	if err != nil {
		c.JSON(200, withError(constant.InternalError))
		return
	}

	c.JSON(200, withSuccess(gin.H{"status": status}))
}

// submitTask 提交任务，等待后台检查
func submitTask(c *gin.Context) {
	_taskId := c.Param("tid")
	taskId, _ := strconv.Atoi(_taskId)
	// userId := c.Query("userId")
	userId := c.GetString("userId")

	if taskId == 0 || userId == "" {
		c.JSON(200, withError(constant.InvalidParam))
		return
	}

	task, err := srv.GetTaskDetail(taskId)
	if err != nil {
		c.JSON(200, withError(constant.InternalError))
		return
	}

	if task == nil {
		c.JSON(200, withError("task not found"))
		return
	}

	exist, err := srv.SubmitTask(taskId, userId, task.Daily)
	if err != nil {
		c.JSON(200, withError(constant.InternalError))
		return
	}

	if exist {
		c.JSON(200, withError("task already submitted"))
		return
	}

	c.JSON(200, withSuccess(gin.H{}))
}
