package config

import (
	"flag"

	"github.com/BurntSushi/toml"
)

type Config struct {
	Debug  bool         `toml:"debug"`
	PGSQL  PGSQLConfig  `toml:"pgsql"`
	Server ServerConfig `toml:"server"`
	TGTask TGTaskConfig `toml:"tg_task"`
}

type SupabaseConfig struct {
	URL      string `toml:"url"`
	APIKey   string `toml:"api_key"`
	Email    string `toml:"email"`
	Password string `toml:"password"`
}

type PGSQLConfig struct {
	Host        string `toml:"host"`
	Port        int    `toml:"port"`
	User        string `toml:"user"`
	Password    string `toml:"password"`
	Database    string `toml:"database"`
	MaxConn     int    `toml:"max_conn"`
	MaxIdleConn int    `toml:"max_idle_conn"`
	EnableLog   bool   `toml:"enable_log"`
}

type TGTaskConfig struct {
	URL string `toml:"url"`
}

type ServerConfig struct {
	Listen string `toml:"listen"`
}

var confPath = flag.String("c", "config.toml", "config file path")

func New() (config *Config, err error) {
	config = new(Config)
	_, err = toml.DecodeFile(*confPath, config)
	return
}
