package constant

import (
	"math/big"
)

const JwtSecret = "VrA1tFnHBhNTPRriHdUQLuFHb4PAFPAa"

const (
	InvalidParam  = "invalid param"
	InternalError = "internal error"
)

var (
	ZeroValue = big.NewInt(0)
	Gwei      = big.NewInt(1000000000)
	Ether     = big.NewInt(1000000000000000000)
)

const (
	TaskPlatformApp      = "app"
	TaskPlatformTwitter  = "twitter"
	TaskPlatformTelegram = "telegram"
)

var validPlatforms = map[string]bool{
	TaskPlatformApp:      true,
	TaskPlatformTwitter:  true,
	TaskPlatformTelegram: true,
}

func IsValidPlatform(platform string) bool {
	_, ok := validPlatforms[platform]
	return ok
}

const (
	TaskActionJoin    = "join"
	TaskActionActive  = "active"
	TaskActionFollow  = "follow"
	TaskActionLike    = "like"
	TaskActionReply   = "reply"
	TaskActionRetweet = "retweet"
	TaskActionInvite  = "invite"
)

var validActions = map[string]bool{
	TaskActionJoin:    true,
	TaskActionActive:  true,
	TaskActionFollow:  true,
	TaskActionLike:    true,
	TaskActionReply:   true,
	TaskActionRetweet: true,
	TaskActionInvite:  true,
}

func IsValidAction(action string) bool {
	_, ok := validActions[action]
	return ok
}

var TaskAction = map[string][]string{
	TaskPlatformApp:      {TaskActionActive, TaskActionInvite},
	TaskPlatformTelegram: {TaskActionJoin, TaskActionActive},
	TaskPlatformTwitter:  {TaskActionFollow, TaskActionLike, TaskActionReply, TaskActionRetweet},
}
