package dao

import (
	"fmt"
	"sdk_api/config"
	dbModel "sdk_api/model/db"
	"time"

	"github.com/supabase-community/supabase-go"
	"gorm.io/driver/postgres"
	"gorm.io/gorm"
	"gorm.io/gorm/logger"
	"gorm.io/gorm/schema"
)

type Dao struct {
	c    *config.Config
	db   *gorm.DB
	supa *supabase.Client
}

func New(_c *config.Config) (dao *Dao, err error) {
	dao = &Dao{
		c: _c,
	}

	// dsn := fmt.Sprintf("%s:%s@tcp(%s:%d)/%s?charset=utf8mb4&parseTime=True",
	// 	_c.PGSQL.User, _c.PGSQL.Password, _c.PGSQL.Host, _c.PGSQL.Port, _c.PGSQL.Database)

	dsn := fmt.Sprintf("host=%s user=%s password=%s dbname=%s port=%d sslmode=verify-ca sslrootcert=ca.crt",
		_c.PGSQL.Host, _c.PGSQL.User, _c.PGSQL.Password, _c.PGSQL.Database, _c.PGSQL.Port,
	)

	lgr := logger.Default
	if _c.PGSQL.EnableLog {
		lgr = logger.Default.LogMode(logger.Info)
	}

	dao.db, err = gorm.Open(postgres.Open(dsn), &gorm.Config{
		NamingStrategy: schema.NamingStrategy{
			SingularTable: true,
		},
		DisableForeignKeyConstraintWhenMigrating: true, // 停用外键约束
		Logger:                                   lgr,
	})
	if err != nil {
		return
	}
	sqlDB, err := dao.db.DB()
	if err != nil {
		return
	}
	sqlDB.SetMaxOpenConns(_c.PGSQL.MaxConn)
	sqlDB.SetMaxIdleConns(_c.PGSQL.MaxIdleConn)
	sqlDB.SetConnMaxIdleTime(time.Hour)
	err = dao.db.AutoMigrate(&dbModel.TaskAction{}, &dbModel.Project{}, &dbModel.TaskGroup{}, &dbModel.Task{}, &dbModel.TaskHistory{})
	if err != nil {
		return
	}
	if err = dao.InitTaskAction(); err != nil {
		panic(err)
	}
	return dao, nil
}
