package dao

import (
	"context"
	"errors"
	"fmt"
	"io"
	"net/http"
	"strings"
	"time"

	log "github.com/sirupsen/logrus"
	"github.com/tidwall/gjson"
)

func (d *Dao) CheckTGJoin(userId, chatId int) (ok bool, err error) {
	url := fmt.Sprintf("%s/api/v1/user/joined?chatId=%d&userId=%d", strings.TrimSuffix(d.c.TGTask.URL, "/"), chatId, userId)
	log.WithField("url", url).Debug("check tg join")
	data, err := httpGet(url)
	if err != nil {
		return false, err
	}

	retCode := gjson.Get(string(data), "code").Int()
	if retCode == 1 {
		return false, errors.New(string(data))
	}

	return gjson.Get(string(data), "data.joined").Bool(), nil
}

func (d *Dao) CheckTGActive(userId, chatId int) (ok bool, err error) {
	url := fmt.Sprintf("%s/api/v1/user/active?chatId=%d&userId=%d", strings.TrimSuffix(d.c.TGTask.URL, "/"), chatId, userId)
	log.WithField("url", url).Debug("check tg active")
	data, err := httpGet(url)
	if err != nil {
		return false, err
	}

	retCode := gjson.Get(string(data), "code").Int()
	if retCode == 1 {
		return false, errors.New(string(data))
	}

	return gjson.Get(string(data), "data.msgCount").Int() > 0, nil
}

func httpGet(url string) ([]byte, error) {
	ctx, cancel := context.WithTimeout(context.Background(), 10*time.Second)
	defer cancel()
	req, err := http.NewRequestWithContext(ctx, "GET", url, nil)
	if err != nil {
		return nil, err
	}
	resp, err := http.DefaultClient.Do(req)
	if err != nil {
		return nil, err
	}
	defer resp.Body.Close()
	return io.ReadAll(resp.Body)
}
