package db_model

import (
	"gorm.io/gorm"
)

type TaskAction struct {
	Id       int    `gorm:"primaryKey;autoIncrement:false"`
	Platform string `gorm:"type:text;uniqueIndex:uidx_platform_action;not null;comment:任务平台"`
	Action   string `gorm:"type:text;uniqueIndex:uidx_platform_action;not null;comment:任务动作"`
	gorm.Model
}

func (t *TaskAction) TableName() string {
	return "taskcenter.task_action"
}

type Project struct {
	Id          int    `gorm:"primaryKey;autoIncrement:false"`
	Name        string `gorm:"type:text;not null;comment:项目名称"`
	Description string `gorm:"type:text;not null;comment:项目描述"`
	gorm.Model

	Groups []*TaskGroup
}

func (p *Project) TableName() string {
	return "taskcenter.project"
}

type TaskGroup struct {
	Id          int    `gorm:"primaryKey;autoIncrement:false"`
	ProjectId   int    `gorm:"type:int;not null;comment:项目id"`
	Description string `gorm:"type:text;not null;comment:任务组描述"`
	gorm.Model
}

func (t *TaskGroup) TableName() string {
	return "taskcenter.task_group"
}

type Task struct {
	Id             int    `gorm:"primaryKey;autoIncrement:false"`
	GroupId        int    `gorm:"type:int;index;not null;comment:任务组id"`
	Platform       string `gorm:"type:text;not null;comment:任务平台"`
	Action         string `gorm:"type:text;not null;comment:任务动作"`
	Url            string `gorm:"type:text;not null;comment:任务链接"`
	TweeterUserId  int    `gorm:"type:int;not null;comment:tweet用户id，用于关注"`
	TweetId        int    `gorm:"type:int;not null;comment:推文id，用于转发点赞等"`
	TelegramChatId int    `gorm:"type:int;not null;comment:telegram群id"`
	Description    string `gorm:"type:text;not null;comment:任务描述"`
	Reward         int    `gorm:"type:int;not null;comment:任务奖励"`
	Start          int    `gorm:"type:int;not null;comment:任务开始时间"`
	End            int    `gorm:"type:int;not null;comment:任务结束时间"`
	Daily          int    `gorm:"type:int;not null;comment:是否是每日任务"`
	gorm.Model
}

func (t *Task) TableName() string {
	return "taskcenter.task"
}

type TaskHistory struct {
	Id       int    `gorm:"primaryKey;autoIncrement:false"`
	TaskId   int    `gorm:"type:int;index;not null;comment:任务id"`
	UserId   string `gorm:"type:uuid;index;not null;comment:用户id"`
	IsReward int    `gorm:"type:int;not null;comment:是否已发放奖励"`
	gorm.Model
}

func (t *TaskHistory) TableName() string {
	return "taskcenter.task_history"
}
