package server

import (
	"sdk_api/constant"
	apiModel "sdk_api/model/api"
	"strconv"

	"github.com/gin-gonic/gin"
)

func createGroup(c *gin.Context) {
	req := &apiModel.CreateGroupRequest{}
	if err := c.ShouldBindJSON(req); err != nil {
		c.JSON(200, withError(constant.InvalidParam))
		return
	}

	if len(req.Tasks) == 0 {
		c.JSON(200, withError(constant.InvalidParam))
		return
	}

	project, err := srv.GetProject(req.ProjectId)
	if err != nil {
		c.JSON(200, withError(constant.InternalError))
		return
	}

	if project == nil {
		c.JSON(200, withError("project not found"))
		return
	}

	for _, task := range req.Tasks {
		if !constant.IsValidAction(task.Action) || !constant.IsValidPlatform(task.Platform) {
			c.JSON(200, withError(constant.InvalidParam))
			return
		}
		if task.Platform == constant.TaskPlatformTelegram && task.TelegramChatId == 0 {
			c.JSON(200, withError(constant.InvalidParam))
			return
		}
		if task.Platform == constant.TaskPlatformTwitter && task.TweetId == 0 && task.TwitterUserId == 0 {
			c.JSON(200, withError(constant.InvalidParam))
			return
		}
	}

	gid, err := srv.CreateGroup(req)
	if err != nil {
		c.JSON(200, withError(constant.InternalError))
		return
	}

	c.JSON(200, withSuccess(gin.H{"groupId": gid}))
}

func getGroup(c *gin.Context) {
	_gid := c.Param("gid")
	gid, _ := strconv.Atoi(_gid)
	if gid == 0 {
		c.JSON(200, withError(constant.InvalidParam))
		return
	}

	resp, err := srv.GetGroup(gid)
	if err != nil {
		c.JSON(200, withError(constant.InternalError))
		return
	}
	c.JSON(200, withSuccess(resp))
}
