package server

import (
	"sdk_api/constant"
	apiModel "sdk_api/model/api"
	"strconv"

	"github.com/gin-gonic/gin"
)

func createProject(c *gin.Context) {
	req := &apiModel.CreateProjectRequest{}
	if err := c.ShouldBindJSON(&req); err != nil {
		c.JSON(200, withError(constant.InvalidParam))
		return
	}

	pid, err := srv.CreateProject(req)
	if err != nil {
		c.JSON(200, withError(constant.InternalError))
		return
	}
	c.JSON(200, withSuccess(gin.H{"projectId": pid}))
}

func listProject(c *gin.Context) {
	_page := c.DefaultQuery("page", "1")
	_pageSize := c.DefaultQuery("pageSize", "10")
	page, _ := strconv.Atoi(_page)
	pageSize, _ := strconv.Atoi(_pageSize)

	if page < 1 || pageSize < 1 || pageSize > 100 {
		c.JSON(200, withError(constant.InvalidParam))
		return
	}

	resp, err := srv.GetProjectList(page, pageSize)
	if err != nil {
		c.JSON(200, withError(constant.InternalError))
		return
	}
	c.JSON(200, withSuccess(resp))
}

func getProject(c *gin.Context) {
	_pid := c.Param("pid")
	pid, _ := strconv.Atoi(_pid)

	if pid == 0 {
		c.JSON(200, withError(constant.InvalidParam))
		return
	}

	resp, err := srv.GetProject(pid)
	if err != nil {
		c.JSON(200, withError(constant.InternalError))
		return
	}
	c.JSON(200, withSuccess(resp))
}
