package server

import (
	"sdk_api/middleware"

	"github.com/gin-gonic/gin"
)

func initRouter(e *gin.Engine) {

	e.Use(middleware.PrintRequestResponseBodyMiddleware())
	v1 := e.Group("/api/v1")

	{
		project := v1.Group("/project")
		project.GET("/:pid", getProject)       // 获取项目详情
		project.GET("/list", listProject)      // 获取项目列表
		project.POST("/create", createProject) // 创建项目
	}

	{
		group := v1.Group("/group")
		group.GET("/:gid", getGroup)       // 获取任务组任务详情
		group.POST("/create", createGroup) // 创建任务组
	}

	{
		task := v1.Group("/task")
		task.GET("/check/:tid", checkTask) // 检查任务是否完成
	}

}
