package server

import (
	"sdk_api/constant"
	"strconv"

	"github.com/gin-gonic/gin"
)

func checkTask(c *gin.Context) {
	_taskId := c.Param("tid")
	taskId, _ := strconv.Atoi(_taskId)
	userId := c.Query("userId")

	if taskId == 0 || userId == "" {
		c.JSON(200, withError(constant.InvalidParam))
		return
	}

	done, expired, err := srv.CheckTask(taskId, userId)
	if err != nil {
		c.JSON(200, withError(constant.InternalError))
		return
	}

	if done || expired {
		c.JSON(200, withSuccess(gin.H{"done": done}))
	}

	done, err = srv.SyncTask(taskId, userId)
	if err != nil {
		c.JSON(200, withError(constant.InternalError))
		return
	}

	c.JSON(200, withSuccess(gin.H{"done": done}))
}
