package service

import (
	apiModel "sdk_api/model/api"
	dbModel "sdk_api/model/db"
	"sdk_api/util"

	log "github.com/sirupsen/logrus"
)

func (s *Service) CreateGroup(req *apiModel.CreateGroupRequest) (gid int, err error) {
	g := &dbModel.TaskGroup{
		Id:          util.GenFlakeID(),
		ProjectId:   req.ProjectId,
		Description: req.Description,
	}
	err = s.d.CreateGroup(g)
	if err != nil {
		log.WithError(err).Error("create group error")
		return
	}

	for _, task := range req.Tasks {
		daily := 0
		if task.Daily {
			daily = 1
		}
		gt := &dbModel.Task{
			Id:             util.GenFlakeID(),
			GroupId:        g.Id,
			Platform:       task.Platform,
			Action:         task.Action,
			Url:            task.Url,
			Description:    task.Description,
			Reward:         task.Reward,
			Start:          task.Start,
			End:            task.End,
			Daily:          daily,
			TweeterUserId:  task.TwitterUserId,
			TweetId:        task.TweetId,
			TelegramChatId: task.TelegramChatId,
		}
		err = s.d.CreateGroupTask(gt)
		if err != nil {
			log.WithError(err).Error("create group task error")
			return 0, err
		}
	}
	return g.Id, nil
}

func (s *Service) GetGroup(gid int) (resp *apiModel.GetGroupResponse, err error) {
	resp = &apiModel.GetGroupResponse{Tasks: make([]apiModel.Task, 0)}
	g, err := s.d.GetGroup(gid)
	if err != nil {
		log.WithError(err).Error("get group error")
		return
	}
	if g == nil {
		log.WithError(err).Error("group not found")
		return nil, nil
	}

	tasks, err := s.d.GetGroupTasks(g.Id)
	if err != nil {
		log.WithError(err).Error("get group tasks error")
		return
	}

	for _, task := range tasks {
		resp.Tasks = append(resp.Tasks, apiModel.Task{
			TaskId:      task.Id,
			Platform:    task.Platform,
			Action:      task.Action,
			Url:         task.Url,
			Description: task.Description,
			Reward:      task.Reward,
			Start:       task.Start,
			End:         task.End,
			Daily:       task.Daily == 1,
		})
	}
	return
}
