package service

import (
	apiModel "sdk_api/model/api"
	dbModel "sdk_api/model/db"
	"sdk_api/util"

	log "github.com/sirupsen/logrus"
)

func (s *Service) CreateProject(req *apiModel.CreateProjectRequest) (pid int, err error) {
	p := &dbModel.Project{
		Id:   util.GenFlakeID(),
		Name: req.ProjectName,
	}
	err = s.d.CreateProject(p)
	if err != nil {
		log.WithError(err).Error("create project error")
		return
	}
	return p.Id, nil
}

func (s *Service) GetProjectList(page, pageSize int) (resp []*apiModel.GetProjectResponse, err error) {
	list, err := s.d.GetProjectList(page, pageSize)
	if err != nil {
		log.WithError(err).Error("get project list error")
		return
	}
	resp = make([]*apiModel.GetProjectResponse, 0)
	for _, v := range list {
		resp = append(resp, &apiModel.GetProjectResponse{
			ProjectName: v.Name,
		})
	}
	return
}

func (s *Service) GetProject(pid int) (resp *apiModel.GetProjectResponse, err error) {
	p, err := s.d.GetProject(pid)
	if err != nil {
		log.WithError(err).Error("get project error")
		return
	}
	if p == nil {
		log.WithError(err).Error("project not found")
		return nil, nil
	}

	return &apiModel.GetProjectResponse{
		ProjectName: p.Name,
	}, nil
}
