package service

import (
	"fmt"
	"sdk_api/constant"
	"time"

	log "github.com/sirupsen/logrus"
)

func (s *Service) CheckTask(taskId int, userId string) (done bool, expired bool, err error) {
	done, err = s.d.IsTaskDone(taskId, userId)
	if err != nil {
		log.WithError(err).Error("is task done error")
		return
	}
	if done {
		return
	}

	task, err := s.d.GetTaskDetail(taskId)
	if err != nil {
		log.WithError(err).Error("get task error")
		return
	}
	if task == nil {
		return
	}

	// 超出时间后只查询不再更新状态
	if int64(task.Start) > time.Now().Unix() || int64(task.End) < time.Now().Unix() {
		expired = true
	}
	return
}

func (s *Service) SyncTask(taskId int, userId string) (done bool, err error) {
	task, err := s.d.GetTaskDetail(taskId)
	if err != nil {
		log.WithError(err).Error("get task error")
		return
	}
	if task == nil {
		return
	}
	// todo get tg user id by userId
	var tgUserId int = 5428144618
	switch task.Platform {
	case constant.TaskPlatformTelegram:
		switch task.Action {
		case constant.TaskActionJoin:
			// 加入群组
			joined, err := s.d.CheckTGJoin(tgUserId, task.TelegramChatId)
			if err != nil {
				log.WithError(err).Error("check tg join error")
				return false, err
			}
			if !joined {
				return false, nil
			}
			err = s.d.CreateTaskHistory(taskId, userId, task.Daily == 1)
			if err != nil {
				log.WithError(err).Error("create task history error")
				return false, err
			}
			return true, nil
		case constant.TaskActionActive:
			// 今日活跃
			activated, err := s.d.CheckTGActive(tgUserId, task.TelegramChatId)
			if err != nil {
				log.WithError(err).Error("check tg active error")
				return false, err
			}
			if !activated {
				return false, nil
			}
			err = s.d.CreateTaskHistory(taskId, userId, task.Daily == 1)
			if err != nil {
				log.WithError(err).Error("create task history error")
				return false, err
			}
			return true, nil
		default:
			return false, fmt.Errorf("unknown task action: %s", task.Action)
		}
	case constant.TaskPlatformTwitter:
		switch task.Action {
		default:
			return false, fmt.Errorf("unknown task action: %s", task.Action)
		}
	default:
		return false, fmt.Errorf("unknown task platform: %s", task.Platform)
	}
}
