package server

import (
	"taskcenter/middleware"

	"github.com/gin-gonic/gin"
)

func initRouter(e *gin.Engine) {

	e.Use(middleware.PrintRequestResponseBodyMiddleware())
	v1 := e.Group("/api/v1")

	{
		group := v1.Group("/group")
		group.GET("/:gid", middleware.JWTMiddleware(d, conf.Supabase.JWTSecret, false), getGroup)      // 获取任务组任务详情
		group.GET("/list", middleware.JWTMiddleware(d, conf.Supabase.JWTSecret, true), listGroup)      // 获取任务组任务详情
		group.POST("/create", middleware.JWTMiddleware(d, conf.Supabase.JWTSecret, true), createGroup) // 创建任务组
	}

	{
		task := v1.Group("/task")
		task.POST("/create", middleware.JWTMiddleware(d, conf.Supabase.JWTSecret, true), createTask)       // 创建任务
		task.POST("/edit", middleware.JWTMiddleware(d, conf.Supabase.JWTSecret, true), editTask)           // 编辑任务
		task.POST("/submit/:tid", middleware.JWTMiddleware(d, conf.Supabase.JWTSecret, false), submitTask) // 提交任务
		task.GET("/check/:tid", middleware.JWTMiddleware(d, conf.Supabase.JWTSecret, false), checkTask)    // 检查任务是否完成
	}

}
