package main

import (
	"code.wuban.net.cn/odysseus/twitter_syncer/core"
	"code.wuban.net.cn/odysseus/twitter_syncer/swarm"
	"encoding/json"
	"flag"
	"fmt"
	"github.com/g8rswimmer/go-twitter/v2"
	"log/slog"
	"os"
	"time"
)

func manual(name string, bee string, sync_all bool) {
	allTask, err := core.GetTasks()
	if err != nil {
		slog.Error("GetTasks", "err", err.Error())
		return
	}
	var todoTask *core.TaskJob
	for _, task := range allTask {
		if task.TaskType == core.FollowType && task.TaskId == name {
			todoTask = &task
			break
		}
	}
	if todoTask.TaskId == "" {
		slog.Error("GetTasks", "err", "not found")
		return
	}

	swarm.InitSwarm([]string{bee})
	cli := swarm.GetSwarm()

	if sync_all {
		todoTask.Idx = []core.UserTask{
			{
				// an non-exist user id.
				UserId: "1",
			},
		}
	}

	page := core.NewPageUsers(core.NewIdx(todoTask.Idx))

	var (
		cursor    = ""
		newCursor = ""
		users     []*twitter.UserObj
	)
	//var maxTime = 20
	for {
		users, newCursor, _, err = cli.GetFollowerList(todoTask.TaskId, todoTask.UserId, cursor)
		if err != nil {
			slog.Error("GetFollowerList", "task id", todoTask.TaskId, "cursor", cursor, "err", err.Error())
			break
		}
		taskUser := core.UserObjectToUserTask(users)
		slog.Info("GetFollowerList", "task id", todoTask.TaskId, "cursor", cursor, "len(users)", len(users), "newCursor", newCursor)
		ok, l := page.GetIdx().Idx(taskUser)
		if ok {
			res := make([]core.UserTask, 0, l.Len())
			for e := l.Front(); e != nil; e = e.Next() {
				if user, ok := e.Value.(core.UserTask); ok {
					res = append(res, user)
				}
			}
			if err := core.InsertTaskRes(res, todoTask.TaskType, todoTask.TaskId); err != nil {
				slog.Error("InsertTaskRes", "task id", todoTask.TaskId,
					"t.TaskType", todoTask.TaskType, "len(users)", len(users), "err", err.Error())
			} else {
				slog.Info("InsertTaskRes", "task id", todoTask.TaskId, "len(users)", len(res))
			}
			return
		} else {
			if newCursor == "" || newCursor == "0" {
				// all followers are found.
				slog.Info("Get all followers finished")
				l := page.GetIdx().List
				res := make([]core.UserTask, 0, l.Len())
				for e := l.Front(); e != nil; e = e.Next() {
					if user, ok := e.Value.(core.UserTask); ok {
						res = append(res, user)
					}
				}
				// save it to json file.
				d, _ := json.MarshalIndent(res, "", "  ")
				filename := fmt.Sprintf("follower-%s.json", todoTask.TaskId)
				err = os.WriteFile(filename, d, 0644)
				if err != nil {
					slog.Error("write followers", "err", err.Error())
				} else {
					slog.Info("write followers", "task id", todoTask.TaskId, "len(users)", len(res))
				}

				if err := core.InsertTaskRes(res, todoTask.TaskType, todoTask.TaskId); err != nil {
					slog.Error("InsertTaskRes", "task id", todoTask.TaskId,
						"t.TaskType", todoTask.TaskType, "len(users)", len(users), "err", err.Error())
				}
				return
			}
		}
		//if (cursor != "" && newCursor == "") || (cursor != "" && newCursor == "0") {
		//	slog.Info("Get all followers finished")
		//	l := page.GetIdx().List
		//	res := make([]core.UserTask, 0, l.Len())
		//	for e := l.Front(); e != nil; e = e.Next() {
		//		if user, ok := e.Value.(core.UserTask); ok {
		//			res = append(res, user)
		//		}
		//	}
		//	// save it to json file.
		//	d, _ := json.MarshalIndent(res, "", "  ")
		//	filename := fmt.Sprintf("follower-%s.json", todoTask.TaskId)
		//	err = os.WriteFile(filename, d, 0644)
		//	if err != nil {
		//		slog.Error("write followers", "err", err.Error())
		//	} else {
		//		slog.Info("write followers", "task id", todoTask.TaskId, "len(users)", len(res))
		//	}
		//
		//	if err := core.InsertTaskRes(res, todoTask.TaskType, todoTask.TaskId); err != nil {
		//		slog.Error("InsertTaskRes", "task id", todoTask.TaskId,
		//			"t.TaskType", todoTask.TaskType, "len(users)", len(users), "err", err.Error())
		//	}
		//	return
		//} else {
		//	ok, l := page.GetIdx().Idx(taskUser)
		//	if ok {
		//		res := make([]core.UserTask, 0, l.Len())
		//		for e := l.Front(); e != nil; e = e.Next() {
		//			if user, ok := e.Value.(core.UserTask); ok {
		//				res = append(res, user)
		//			}
		//		}
		//		if err := core.InsertTaskRes(res, todoTask.TaskType, todoTask.TaskId); err != nil {
		//			slog.Error("InsertTaskRes", "task id", todoTask.TaskId,
		//				"t.TaskType", todoTask.TaskType, "len(users)", len(users), "err", err.Error())
		//		} else {
		//			slog.Info("InsertTaskRes", "task id", todoTask.TaskId, "len(users)", len(res))
		//		}
		//		return
		//	}
		//}

		if newCursor == "" || newCursor == "0" {
			break
		}

		cursor = newCursor
		time.Sleep(time.Second * 1)
	}

}

var (
	taskname = flag.String("task", "", "task name")
	bee      = flag.String("bee", "http://127.0.0.1:8088", "bee url")
	syncAll  = flag.Bool("a", false, "sync all followers of the task")
)

func main() {
	flag.Parse()
	manual(*taskname, *bee, *syncAll)
}
