package main

import (
	"code.wuban.net.cn/odysseus/twitter_syncer/core"
	"encoding/json"
	"flag"
	"log/slog"
	"os"
)

func write(name string, file string) {
	allTask, err := core.GetTasks()
	if err != nil {
		slog.Error("GetTasks", "err", err.Error())
		return
	}
	var todoTask *core.TaskJob
	for _, task := range allTask {
		if task.TaskType == core.FollowType && task.TaskId == name {
			todoTask = &task
			break
		}
	}
	if todoTask.TaskId == "" {
		slog.Error("GetTasks", "err", "not found")
		return
	}
	data, err := os.ReadFile(file)
	if err != nil {
		slog.Error("read file", "err", err.Error())
		return
	}
	var users []core.UserTask
	err = json.Unmarshal(data, &users)
	if err != nil {
		slog.Error("unmarshal", "err", err.Error())
		return
	}

	if err := core.InsertTaskRes(users, todoTask.TaskType, todoTask.TaskId); err != nil {
		slog.Error("InsertTaskRes", "task id", todoTask.TaskId,
			"t.TaskType", todoTask.TaskType, "len(users)", len(users), "err", err.Error())
	}

}

var (
	taskname = flag.String("task", "", "task name")
	file     = flag.String("file", "", "write file name")
)

func main() {
	flag.Parse()
	write(*taskname, *file)
}
