package main

import (
	"context"
	"encoding/json"
	"golang.org/x/time/rate"
	"net/http"
	"os"
	"strings"
	"testing"
	"time"

	twitterscraper "github.com/imperatrona/twitter-scraper"
)

/*
 {"Avatar":"https://pbs.twimg.com/profile_images/1812708680594296832/TkKsEyvW_normal.jpg","Banner":"https://pbs.twimg.com/profile_banners/1783145144700874752/1721029871","Biography":"#AON: The best way to quickly build and share Web3 #Al Apps\n\nJoin our community: https://t.co/ECV29IujSK","Birthday":"","FollowersCount":19697,"FollowingCount":72,"FriendsCount":37,"IsPrivate":false,"IsVerified":false,"Joined":"2024-04-24T14:45:19Z","LikesCount":72,"ListedCount":3,"Location":"Hong Kong ","Name":"AON","PinnedTweetIDs":["1800805503066661056"],"TweetsCount":129,"URL":"https://twitter.com/aon_aonet","UserID":"1783145144700874752","Username":"aon_aonet","Website":"https://aonnet.io/","Sensitive":false,"Following":false,"FollowedBy":false}

*/

func TestProfile(t *testing.T) {

	scraper := twitterscraper.New()

	i := 0

	for {

		i = i + 1

		t.Log(i, time.Now())

		pro, err := scraper.GetProfile("aon_aonet")

		if err != nil {
			t.Fatal(err)
		}

		proAsJson, err := json.Marshal(pro)

		if err != nil {
			t.Fatal(err)
		}

		t.Log(string(proAsJson))

		t.Log(pro.FollowersCount)

		time.Sleep(time.Second)
	}

}

func TestAccounts(t *testing.T) {

	accounts, err := GetAvailableAccounts()

	if err != nil {
		t.Fatal(err)
	}

	for k, v := range accounts {
		t.Log(k, v)
	}

}

// func TestSetCookies(t *testing.T) {

// 	accounts, err := GetAvailableAccounts()

// 	if err != nil {
// 		t.Fatal(err)
// 	}

// 	// for k, v := range accounts {
// 	// 	t.Log(k, v)
// 	// }

// 	data, err := json.Marshal(accounts)

// 	if err != nil {
// 		t.Fatal(err)
// 	}

// 	for _, v := range accounts {
// 		//t.Log(k, v)
// 		if err := UpdateCookies(v.Username, data); err != nil {
// 			t.Fatal(err)
// 		}
// 	}
// }

func TestGetLoginAccount(t *testing.T) {

	accounts, err := GetLoginAccount()

	if err != nil {
		t.Fatal(err)
	}

	t.Log("login account ok")

	for _, v := range accounts {
		//v.Timer = time.NewTimer(time.Duration(k) * time.Duration(5) * time.Minute)
		accChan <- v
	}

	for {
		select {
		case account := <-accChan:

			<-account.Timer.C

			users, _, err := account.WithDelay(300).FetchFollowers("bitcoin", 20, "")
			if err != nil {
				t.Log(err.Error())
				continue
			}

			t.Log("len(users)", len(users), time.Now())

			account.Timer = time.NewTimer(time.Hour)
			accChan <- account

		}

	}
}

func TestCookies(t *testing.T) {

	scraper := twitterscraper.New()

	var cookies []*http.Cookie
	f, _ := os.Open("16.json")
	if err := json.NewDecoder(f).Decode(&cookies); err != nil {
		t.Fatal(err)
	}

	t.Log("len(cookies)", len(cookies))

	scraper.SetCookies(cookies)
	if !scraper.IsLoggedIn() {
		panic("Invalid cookies")
	}

	// users, _, err := scraper.FetchFollowers("bitcoin", 20, "")
	// if err != nil {
	// 	t.Log(err.Error())
	// 	continue
	// }

}

func TestRateLimiter(t *testing.T) {
	rl := rate.NewLimiter(rate.Limit(1.0/60), 10)
	ctx := context.TODO()
	for i := 0; i < 20; i++ {
		rl.Wait(ctx)
		t.Log(i, time.Now())
		time.Sleep(1 * time.Second)
	}
}

func TestAddAccount(t *testing.T) {
	acclist := `ADeirdre20860----PtmcQvWd1DoD----tlugmeqmyt@rambler.ru----1589408cnVMmCa----P7G5GRG7ULCYKBMY----808f3b93ac4f9b0ac5085a3b1ba608e1c1a8e675
EulaSusann56500----SuIZROXhN14D----szahcqejrt@rambler.ru----9911065aAPM8ga----XDC6WMJEH4ILTTXN----f44e136089679d62247f353570be9cc78c60ff6b
MShondra82485----B7P38LYzz----mvwadpmfxr@rambler.ru----5973556MwG4gqa----I6XQJHQMUUL5MDXX----a43cbb2fd4a891e0513169131fe7dc7a0bb54f1f
KylieBritt10079----up1kj10rgjkry----xttuuxbtdc@rambler.ru----9507993gP7QJCa----GDZ6QWDQ5Q2KDOE5----330f127059d8a686cc0bc82e12aac5380fce9b03
StevieJ95145----9XqzE8JBSd----kkkfqtgkym@rambler.ru----5141799R36rxaa----ZFRHKNVV3TAU6GJ6----55bbfe00bfc34c4e9e7cc6d46eef0cd79ff31284`
	accs := strings.Split(acclist, "\n")
	for _, v := range accs {
		info := strings.Split(v, "----")
		if len(info) != 6 {
			t.Errorf("invalid account info %s", v)
		} else {
			record := Account{
				Username:  info[0],
				Password:  info[1],
				Email:     info[2],
				F2A:       info[4],
				Available: true,
			}
			if err := AddAccount(record); err != nil {
				t.Error(err)
			} else {
				t.Logf("add account %s success", record.Username)
			}
		}
	}
}
func TestLogin(t *testing.T) {
	//userCookies := make(map[string][]*http.Cookie)
	info := []struct {
		Username string `json:"username"`
		Password string `json:"password"`
		Email    string `json:"email"`
		F2A      string `json:"f2a"`
	}{
		//{"EulaSusann56500", "SuIZROXhN14D", "szahcqejrt@rambler.ru", "XDC6WMJEH4ILTTXN"},
		{"MShondra82485", "B7P38LYzz", "mvwadpmfxr@rambler.ru", "I6XQJHQMUUL5MDXX"},
		//{"KylieBritt10079", "up1kj10rgjkry", "xttuuxbtdc@rambler.ru", "GDZ6QWDQ5Q2KDOE5"},
	}
	tasks := make(chan string, 1000)

	type HistoryInfo struct {
		Users []string
		Next  string
	}
	filter := func(users []string, history *HistoryInfo) []string {
		if history == nil {
			return users
		}
		m := make(map[string]bool)
		for _, v := range history.Users {
			m[v] = true
		}
		newusers := make([]string, 0, 1000)
		for _, v := range users {
			if _, ok := m[v]; !ok {
				newusers = append(newusers, v)
			}
		}
		return newusers
	}
	history := make(map[string]*HistoryInfo)

	tasks <- "sager"

	accounts := make(map[string]*twitterscraper.Scraper)
	for _, v := range info {
		scraper := twitterscraper.New()
		code, err := generateTOTP(v.F2A)
		if err != nil {
			t.Fatal(err)
		}
		{
			if err := scraper.AutoLogin(v.Username, v.Password, v.Email, code); err != nil {
				t.Error(err)
				continue
			} else {
				t.Log("login success")
				accounts[v.Username] = scraper
			}
		}
	}
	for {
		select {
		case task := <-tasks:
			tHistory := history[task]
			if tHistory == nil {
				tHistory = &HistoryInfo{}
			}
			for k, v := range accounts {
				newusers := make([]string, 0, 1000)
				users, next, err := v.FetchFollowers(task, 1000, tHistory.Next)
				if err != nil {
					t.Error("fetch followers error", err, "now", time.Now())
					if strings.Contains(err.Error(), "429") {
						time.Sleep(1 * time.Minute)
					}
					continue
				}
				for _, u := range users {
					newusers = append(newusers, u.UserID)
				}

				tHistory.Users = append(tHistory.Users, filter(newusers, tHistory)...)
				tHistory.Next = next
				if len(users) == 0 {
					t.Logf("query follower with username:%s, next:%s, newuser=0",
						k, next)
				} else {
					t.Logf("query follower with username:%s, next:%s, newuser[0]=%s, newusercount=%d",
						k, next, users[0].Username, len(users))
				}
				time.Sleep(1 * time.Second)
			}
			history[task] = tHistory
			tasks <- task
		}
	}

}
