package main

import (
	"testing"
	"time"
)

func TestTime(t *testing.T) {

	data, count, err := client.From("tweet_liking_users").Select("*", "exact", false).Eq("task_id", "1800805503066661056").Eq("user_id", "1823984946710765569").Gt("created_at", "2024-08-17T13:18:18.505072+00:00").Lt("created_at", "2024-08-18T13:18:19.505072+00:00").Execute()

	if err != nil {
		t.Fatal(err.Error())
	}

	t.Log(string(data))
	t.Log(count)

	//return count == 1, nil
	//2006-01-02 15:04:05
	//2024-01-01T00:00:00Z

	parseTime, err := time.Parse("2006-01-02T15:04:05Z", "2024-01-01T00:00:06Z")
	if err != nil {
		t.Fatal(err.Error())
	}
	t.Log(parseTime.String())

	t.Log(parseTime.Format("2006-01-02T15:04:05.000000+00:00"))
}
