package main

import (
	"encoding/json"
	"fmt"
	"testing"
)

func TestMe(t *testing.T) {

	//cli := NewOAuth2Client()

	cli := NewOAuth2Client0817()

	me, err := cli.Me()

	if err != nil {
		t.Error(err)
	}

	t.Log("Me")

	meAsJson, err := json.Marshal(me)

	if err != nil {
		t.Error(err)
	}

	t.Log(string(meAsJson))

}

func TestCfg(t *testing.T) {

	cfg := Config{
		ApiKey:            "u5HOlaBhMFNqXbs7lznEuUQVx",
		ApiKeySecrect:     "VhpTsl4TJUQi9FSAymajDCWfpgyJoK2d18i4lX9sPGiWc462nR",
		AccessToken:       "1783145144700874752-F38iX5PVmnOe3RHKwB0mc8tj4vObaT",
		AccessTokenSecret: "O8BhSezZA8M8Jlz0rZJReBsV9HZO420iWdU58wCG2BXaA",
		Token:             "AAAAAAAAAAAAAAAAAAAAAIZTwQEAAAAApSMHaI24HWCEVYV0mx%2F2HauZHI0%3D6GrtIbJbiAwGJr4rZIz4WdrTLO6qI4zRGN4ZKpaOqUbwRRauPI",
	}

	cfgAsJson, err := json.Marshal(cfg)

	if err != nil {
		t.Fatal(err)
	}

	t.Log(string(cfgAsJson))

}

func TestGetLikeUsers(t *testing.T) {
	cfg := Config{
		ApiKey:            "u5HOlaBhMFNqXbs7lznEuUQVx",
		ApiKeySecrect:     "VhpTsl4TJUQi9FSAymajDCWfpgyJoK2d18i4lX9sPGiWc462nR",
		AccessToken:       "1783145144700874752-F38iX5PVmnOe3RHKwB0mc8tj4vObaT",
		AccessTokenSecret: "O8BhSezZA8M8Jlz0rZJReBsV9HZO420iWdU58wCG2BXaA",
		Token:             "AAAAAAAAAAAAAAAAAAAAAIZTwQEAAAAApSMHaI24HWCEVYV0mx%2F2HauZHI0%3D6GrtIbJbiAwGJr4rZIz4WdrTLO6qI4zRGN4ZKpaOqUbwRRauPI",
	}
	cc := NewLikeClient(cfg)
	users, nextToken, nextTime, err := cc.TweetLikingUsers("1843181642300674228", "")
	if err != nil {
		t.Error(err)
	}
	t.Log("nextToken", nextToken, "nextTime", nextTime)
	for _, user := range users {
		fmt.Printf("user: %s, %s\n", user.ID, user.UserName)
	}
}
