package main

import (
	_ "code.wuban.net.cn/odysseus/twitter_syncer/docs"
	"encoding/json"
	"fmt"
	"log/slog"
	// docs are generated by Swag CLI, you have to import them.
	// replace with your own docs folder, usually "github.com/username/reponame/docs"
	//_ "github.com/gofiber/swagger/example/docs"

	"github.com/supabase-community/postgrest-go"
	"github.com/supabase-community/supabase-go"
)

var client *supabase.Client

func init() {

	//var API_URL = "http://43.198.54.207:8000"
	//var API_KEY = "eyJhbGciOiJIUzI1NiIsInR5cCI6IkpXVCJ9.eyAgCiAgICAicm9sZSI6ICJzZXJ2aWNlX3JvbGUiLAogICAgImlzcyI6ICJzdXBhYmFzZS1kZW1vIiwKICAgICJpYXQiOiAxNjQxNzY5MjAwLAogICAgImV4cCI6IDE3OTk1MzU2MDAKfQ.DaYlNEoUrrEn2Ig7tqibS-PHK5vgusbcbo7X36XVt4Q"
	var API_URL = "https://api.iaon.ai"
	var API_KEY = "eyJhbGciOiJIUzI1NiIsInR5cCI6IkpXVCJ9.eyJpc3MiOiJzdXBhYmFzZSIsInJlZiI6InZieHR2amZmaHNpcm55eGpjdWt1Iiwicm9sZSI6InNlcnZpY2Vfcm9sZSIsImlhdCI6MTcyMjUxNjU2NCwiZXhwIjoyMDM4MDkyNTY0fQ.1IvdUdoQu5yNHllvFQA_tFGDSbydAB5bjFSCxXcZ260"
	for {
		cli, err := supabase.NewClient(API_URL, API_KEY, &supabase.ClientOptions{
			Schema: "twitter",
		})
		if err != nil {
			slog.Error("supabase.NewClient", "err", err.Error())
			return
		} else {
			client = cli
			break
		}
	}

	accounts, err := GetLoginAccount()

	if err != nil {
		slog.Error(err.Error())
	}

	for _, v := range accounts {
		//v.Timer = time.NewTimer(time.Duration(k) * time.Duration(5) * time.Minute)
		accChan <- v
	}
}

const FollowType = "followers"
const RetweetType = "retweeters"
const TweetLikingUsersType = "tweet_liking_users"

//UserTask

type TaskRes struct {
	UserTask
	Id        int    `json:"id"`
	CreatedAt string `json:"created_at"`
}

type UserTaskIdAndTime struct {
	TaskInDB
	Id        int    `json:"id"`
	CreatedAt string `json:"created_at"`
}

type ApiConfig struct {
	ApiKey            string `json:"api_key"`
	ApiKeySecrect     string `json:"api_key_secret"`
	AccessToken       string `json:"access_token"`
	AccessTokenSecret string `json:"access_token_secret"`
	Token             string `json:"token"`
}

type TaskInDB struct {
	// ID       int    `json:"id"`
	User          string `json:"user_id"`
	TaskType      string `json:"task_type"`
	TaskId        string `json:"task_id"`
	ApiConfig     string `json:"api_config"`
	Start         bool   `json:"start"`
	Stop          bool   `json:"stop"`
	FollowerCount int    `json:"follower_count"`
}

func QueryAllTask() ([]TaskInDB, error) {

	data, count, err := client.From("tasks").Select("*", "exact", false).
		Eq("start", "true").Neq("stop", "true").
		Execute()

	if err != nil {
		return nil, err
	}

	_ = count

	// fmt.Println(count, string(data))

	res := make([]TaskInDB, 0, count)

	if err := json.Unmarshal(data, &res); err != nil {
		return nil, err
	}

	return res, nil

}

type TaskJob struct {
	TaskId   string
	Idx      []UserTask
	UserId   string
	TaskType string
	Config
	FollowerCount int
}

func (job *TaskJob) String() string {

	jobAsJson, _ := json.Marshal(job)
	return string(jobAsJson)
}

func parseToConfig(api string) Config {
	cfg := Config{}
	if err := json.Unmarshal([]byte(api), &cfg); err != nil {
		return Config{}
	} else {
		return cfg
	}
}

func parseToApiConfig(cfg Config) string {
	api := ApiConfig{
		ApiKey:            cfg.ApiKey,
		ApiKeySecrect:     cfg.ApiKeySecrect,
		AccessToken:       cfg.AccessToken,
		AccessTokenSecret: cfg.AccessTokenSecret,
		Token:             cfg.Token,
	}
	d, _ := json.Marshal(api)
	return string(d)
}

func GetTasks() ([]TaskJob, error) {

	tasks, err := QueryAllTask()
	for _, task := range tasks {
		fmt.Println("GetTasks", task)
	}

	if err != nil {
		return nil, err
	}

	res := make([]TaskJob, 0, 10)

	for _, task := range tasks {
		if len(task.ApiConfig) == 0 {
			continue
		}
		// get idx data from each task table.
		data, count, err := client.From(task.TaskType).Select("", "user_id", false).
			Eq("task_id", task.TaskId).
			Order("id", &postgrest.OrderOpts{
				Ascending: false,
				// NullsFirst   bool
				// ForeignTable string
			}).Range(0, 10, "").Execute()

		if err != nil {
			slog.Error("select * from followers error", err)
			return nil, err
		}
		_ = count

		slog.Info("idx data", "user id", task.TaskId, "user name", task.User, "idx", data)

		fmt.Println("idx data", string(data))

		userRes := make([]UserTask, 0, 10)

		if err := json.Unmarshal(data, &userRes); err != nil {
			return nil, err
		}

		taskJob := TaskJob{
			Idx:           userRes,
			UserId:        task.User,
			TaskType:      task.TaskType,
			TaskId:        task.TaskId,
			FollowerCount: task.FollowerCount,
			Config:        parseToConfig(task.ApiConfig),
		}

		res = append(res, taskJob)

	}

	return res, nil
}

type UserTask struct {
	//user_id
	TaskId   string `json:"task_id"`
	UserId   string `json:"user_id"`
	UserName string `json:"user_name"`
}

func InsertTaskRes(content []UserTask, tableName string, taskId string) error {

	rows := make([]UserTask, 0, len(content))

	for _, v := range content {
		v.TaskId = taskId
		rows = append(rows, v)
	}

	res, _, err := client.From(tableName).Insert(rows, true, "", "representation", "").Execute()

	if err != nil {
		return err
	}

	_ = res
	return nil
}
