package main

import (
	"encoding/json"
	"fmt"
	"testing"
)

func TestQueryTask(t *testing.T) {

	tasks, err := QueryAllTask()

	if err != nil {
		t.Fatal(err)
	}

	for k, v := range tasks {

		t.Log(k, "v.User", v.User, "v.TaskType", v.TaskType, "v.TaskId", v.TaskId)
	}

}

//GetTasks()

func TestAddTasks(t *testing.T) {
	cfg := Config{
		ApiKey:            "u5HOlaBhMFNqXbs7lznEuUQVx",
		ApiKeySecrect:     "VhpTsl4TJUQi9FSAymajDCWfpgyJoK2d18i4lX9sPGiWc462nR",
		AccessToken:       "1783145144700874752-F38iX5PVmnOe3RHKwB0mc8tj4vObaT",
		AccessTokenSecret: "O8BhSezZA8M8Jlz0rZJReBsV9HZO420iWdU58wCG2BXaA",
		Token:             "AAAAAAAAAAAAAAAAAAAAAIZTwQEAAAAApSMHaI24HWCEVYV0mx%2F2HauZHI0%3D6GrtIbJbiAwGJr4rZIz4WdrTLO6qI4zRGN4ZKpaOqUbwRRauPI",
	}
	task := TaskInDB{
		User:          "1783145144700874752",
		TaskType:      "tweet_liking_users",
		TaskId:        "1800805503066661056",
		ApiConfig:     parseToApiConfig(cfg),
		Start:         true,
		Stop:          true,
		FollowerCount: 0,
	}
	res, _, err := client.From("tasks").Insert(task, true, "", "representation", "").Execute()
	if err != nil {
		t.Fatal(err)
	}
	t.Log(res)
}

func TestGetTaskInDB(t *testing.T) {
	data, count, err := client.From("tasks").Select("*", "exact", false).
		Eq("start", "true").Eq("stop", "true").
		Execute()

	if err != nil {
		t.Fatal(err)
	}

	fmt.Println("found count", count)

	res := make([]TaskInDB, 0, count)

	if err := json.Unmarshal(data, &res); err != nil {
		t.Fatal(err)
	}

	for k, v := range res {
		t.Log(k, "v.User", v.User, "v.TaskType", v.TaskType, "v.TaskId", v.TaskId, "v.Config", v.ApiConfig)
	}
}

func TestGetTasks(t *testing.T) {

	tasks, err := GetTasks()

	if err != nil {
		t.Fatal(err)
	}

	for k, v := range tasks {

		t.Log(k, "v.User", v.UserId, "v.TaskType", v.TaskType, "v.TaskId", v.TaskId, "Token", v.Token, "accessToken", v.AccessToken)
	}

	//exist, err := CheckTaskExist("1783145144700874752", "aon_aonet", "followers")
	//if err != nil {
	//	t.Fatal(err)
	//}
	//t.Log("exist", exist)

}

// func TestInsertTask(t *testing.T) {

// 	req := Req{
// 		Project: "1",
// 		TweetId: "11",
// 	}

// 	err := Insert(req)
// 	if err != nil {
// 		t.Fatal(err)
// 	}

// 	// fmt.Println("found", ok, task)
// }

// func TestTwitterAccountFromDB(t *testing.T) {

// 	accounts, err := TwitterAccountFromDB()
// 	if err != nil {
// 		t.Fatal(err)
// 	}

// 	for k, v := range accounts {
// 		t.Log(k, v.User, v.PassWd)
// 	}

// 	// fmt.Println("found", ok, task)
// }
