// Package docs Code generated by swaggo/swag. DO NOT EDIT
package docs

import "github.com/swaggo/swag"

const docTemplate = `{
    "schemes": {{ marshal .Schemes }},
    "swagger": "2.0",
    "info": {
        "description": "{{escape .Description}}",
        "title": "{{.Title}}",
        "contact": {
            "name": "API Support",
            "url": "http://www.swagger.io/support",
            "email": "support@swagger.io"
        },
        "license": {
            "name": "Apache 2.0",
            "url": "http://www.apache.org/licenses/LICENSE-2.0.html"
        },
        "version": "{{.Version}}"
    },
    "host": "{{.Host}}",
    "basePath": "{{.BasePath}}",
    "paths": {
        "/apikey/owner": {
            "get": {
                "description": "get config owner info.",
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "config"
                ],
                "summary": "GetConfigOwner",
                "parameters": [
                    {
                        "description": "config",
                        "name": "config",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/main.Config"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/main.ProjectRes"
                        }
                    },
                    "400": {
                        "description": "Bad Request",
                        "schema": {
                            "$ref": "#/definitions/main.Res"
                        }
                    },
                    "500": {
                        "description": "Internal Server Error",
                        "schema": {
                            "$ref": "#/definitions/main.Res"
                        }
                    }
                }
            }
        },
        "/project": {
            "post": {
                "description": "add project info.",
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "project"
                ],
                "summary": "Project",
                "parameters": [
                    {
                        "description": "project",
                        "name": "project",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/main.ProjectReq"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/main.ProjectRes"
                        }
                    },
                    "400": {
                        "description": "Bad Request",
                        "schema": {
                            "$ref": "#/definitions/main.Res"
                        }
                    },
                    "500": {
                        "description": "Internal Server Error",
                        "schema": {
                            "$ref": "#/definitions/main.Res"
                        }
                    }
                }
            }
        },
        "/task/add": {
            "post": {
                "description": "add task info.",
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "task"
                ],
                "summary": "TaskAdd",
                "parameters": [
                    {
                        "description": "task",
                        "name": "task",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/main.AddTaskReq"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/main.Res"
                        }
                    },
                    "400": {
                        "description": "Bad Request",
                        "schema": {
                            "$ref": "#/definitions/main.Res"
                        }
                    },
                    "500": {
                        "description": "Internal Server Error",
                        "schema": {
                            "$ref": "#/definitions/main.Res"
                        }
                    }
                }
            }
        },
        "/task/stop": {
            "post": {
                "description": "stop task info.",
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "task"
                ],
                "summary": "TaskStop",
                "parameters": [
                    {
                        "description": "task",
                        "name": "task",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/main.StopTaskReq"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/main.Res"
                        }
                    },
                    "400": {
                        "description": "Bad Request",
                        "schema": {
                            "$ref": "#/definitions/main.Res"
                        }
                    },
                    "500": {
                        "description": "Internal Server Error",
                        "schema": {
                            "$ref": "#/definitions/main.Res"
                        }
                    }
                }
            }
        },
        "/verify/follower": {
            "get": {
                "description": "verify follower info.",
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "verify"
                ],
                "summary": "VerifyFollower",
                "parameters": [
                    {
                        "type": "string",
                        "description": "task_id",
                        "name": "task_id",
                        "in": "query",
                        "required": true
                    },
                    {
                        "type": "string",
                        "description": "follower_id",
                        "name": "follower_id",
                        "in": "query",
                        "required": true
                    },
                    {
                        "type": "string",
                        "description": "follower_username",
                        "name": "follower_username",
                        "in": "query",
                        "required": true
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/main.VerifyRes"
                        }
                    },
                    "400": {
                        "description": "Bad Request",
                        "schema": {
                            "$ref": "#/definitions/main.Res"
                        }
                    },
                    "500": {
                        "description": "Internal Server Error",
                        "schema": {
                            "$ref": "#/definitions/main.Res"
                        }
                    }
                }
            }
        },
        "/verify/like": {
            "get": {
                "description": "verify like info.",
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "verify"
                ],
                "summary": "VerifyLike",
                "parameters": [
                    {
                        "type": "string",
                        "description": "tweet_id",
                        "name": "tweet_id",
                        "in": "query",
                        "required": true
                    },
                    {
                        "type": "string",
                        "description": "user_id",
                        "name": "user_id",
                        "in": "query",
                        "required": true
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/main.VerifyRes"
                        }
                    },
                    "400": {
                        "description": "Bad Request",
                        "schema": {
                            "$ref": "#/definitions/main.Res"
                        }
                    },
                    "500": {
                        "description": "Internal Server Error",
                        "schema": {
                            "$ref": "#/definitions/main.Res"
                        }
                    }
                }
            }
        },
        "/verify/retweeter": {
            "get": {
                "description": "verify retweeter info.",
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "verify"
                ],
                "summary": "VerifyRetweeter",
                "parameters": [
                    {
                        "type": "string",
                        "description": "tweet_id",
                        "name": "tweet_id",
                        "in": "query",
                        "required": true
                    },
                    {
                        "type": "string",
                        "description": "retweeter_id",
                        "name": "retweeter_id",
                        "in": "query",
                        "required": true
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/main.VerifyRes"
                        }
                    },
                    "400": {
                        "description": "Bad Request",
                        "schema": {
                            "$ref": "#/definitions/main.Res"
                        }
                    },
                    "500": {
                        "description": "Internal Server Error",
                        "schema": {
                            "$ref": "#/definitions/main.Res"
                        }
                    }
                }
            }
        }
    },
    "definitions": {
        "main.AddTaskReq": {
            "type": "object",
            "properties": {
                "config": {
                    "$ref": "#/definitions/main.Config"
                },
                "task_id": {
                    "type": "string"
                },
                "task_type": {
                    "type": "string"
                },
                "user_id": {
                    "type": "string"
                }
            }
        },
        "main.Config": {
            "type": "object",
            "properties": {
                "access_token": {
                    "type": "string"
                },
                "access_token_secret": {
                    "type": "string"
                },
                "api_key": {
                    "type": "string"
                },
                "api_key_secret": {
                    "type": "string"
                },
                "token": {
                    "type": "string"
                }
            }
        },
        "main.ProjectReq": {
            "type": "object",
            "properties": {
                "access_token": {
                    "type": "string"
                },
                "access_token_secret": {
                    "type": "string"
                },
                "api_key": {
                    "type": "string"
                },
                "api_key_secret": {
                    "type": "string"
                },
                "project": {
                    "type": "string"
                },
                "token": {
                    "type": "string"
                }
            }
        },
        "main.ProjectRes": {
            "type": "object",
            "properties": {
                "code": {
                    "type": "integer"
                },
                "data": {
                    "$ref": "#/definitions/main.UserInfo"
                },
                "msg": {
                    "type": "string"
                }
            }
        },
        "main.Res": {
            "type": "object",
            "properties": {
                "code": {
                    "type": "integer"
                },
                "msg": {
                    "type": "string"
                }
            }
        },
        "main.StopTaskReq": {
            "type": "object",
            "properties": {
                "task_id": {
                    "type": "string"
                },
                "task_type": {
                    "type": "string"
                },
                "user_id": {
                    "type": "string"
                }
            }
        },
        "main.UserInfo": {
            "type": "object",
            "properties": {
                "name": {
                    "type": "string"
                },
                "user_id": {
                    "type": "string"
                },
                "username": {
                    "type": "string"
                }
            }
        },
        "main.VerifyRes": {
            "type": "object",
            "properties": {
                "code": {
                    "type": "integer"
                },
                "data": {
                    "type": "object",
                    "properties": {
                        "ok": {
                            "type": "boolean"
                        }
                    }
                },
                "msg": {
                    "type": "string"
                }
            }
        }
    }
}`

// SwaggerInfo holds exported Swagger Info so clients can modify it
var SwaggerInfo = &swag.Spec{
	Version:          "1.0",
	Host:             "localhost:8001",
	BasePath:         "/",
	Schemes:          []string{},
	Title:            "Twitter Syncer API",
	Description:      "This is api for twitter syncer.",
	InfoInstanceName: "swagger",
	SwaggerTemplate:  docTemplate,
	LeftDelim:        "{{",
	RightDelim:       "}}",
}

func init() {
	swag.Register(SwaggerInfo.InstanceName(), SwaggerInfo)
}
