// @title Twitter Syncer API
// @version 1.0
// @description This is api for twitter syncer.

// @contact.name API Support
// @contact.url http://www.swagger.io/support
// @contact.email support@swagger.io

// @license.name Apache 2.0
// @license.url http://www.apache.org/licenses/LICENSE-2.0.html

// @host localhost:8001
// @BasePath /

package main

import (
	"code.wuban.net.cn/odysseus/twitter_syncer/core"
	"code.wuban.net.cn/odysseus/twitter_syncer/swarm"
	"flag"
	"fmt"
	"github.com/gofiber/swagger"
	"log/slog"
	"strings"

	"github.com/gofiber/fiber/v2"
	"github.com/gofiber/fiber/v2/middleware/cors"

	_ "code.wuban.net.cn/odysseus/twitter_syncer/docs"
)

var (
	beeFlag = flag.String("bee", "", "initial bees to use fetch follower")
)

func main() {
	flag.Parse()
	bees := strings.Split(*beeFlag, ",")
	swarm.InitSwarm(bees)

	done := make(chan interface{})

	defer close(done)

	tasks, err := core.GetTasks()

	if err != nil {
		slog.Error(err.Error())
		return
	}

	go func() {

		for _, task := range tasks {
			fmt.Println(task.String())
			if err := core.Worker.AddJob(task); err != nil {
				slog.Error(err.Error())
			}
		}
	}()

	// remove acmanager.
	//manager := acmanager.NewManager(core.DBClient)
	//manager.Start()

	// taskIn = taskInStream

	app := fiber.New()

	app.Use(cors.New())

	//app.Static("/swagger/docs", "./docs")

	//cfg := swagger.Config{
	//	BasePath: "/",
	//	FilePath: "./docs/swagger.yaml",
	//	Path:     "swagger",
	//	Title:    "Swagger API Docs",
	//}
	//
	//app.Use(swagger.New(cfg))
	app.Get("/swagger/*", swagger.HandlerDefault)

	app.Post("/project", core.Project)
	app.Get("/apikey/owner", core.GetConfigOwner)
	app.Post("/task/add", core.TaskAdd)
	app.Post("/task/stop", core.TaskStop)
	app.Get("/verify/follower", core.VerifyFollower)
	app.Get("/verify/retweeter", core.VerifyRetweeter)
	app.Post("/bee/add", core.BeeAdd)
	app.Post("/bee/del", core.BeeDel)
	//VerifyLike
	app.Get("/verify/like", core.VerifyLike)

	if err := app.Listen(":8001"); err != nil {
		slog.Error(err.Error())
	}
}

// type ReqDB struct {
// 	AddOrStop bool
// 	Project   string `json:"project"`
// 	TweetId   string `json:"tweet_id"`
// 	Like      bool   `json:"like"`
// 	Retweet   bool   `json:"retweet"`
// }
