package main

import (
	"testing"
	"github.com/hyperledger/fabric/core/chaincode/shim"
	"fmt"
	"encoding/json"
	"encoding/hex"
)

var orgPublicKey = "04e57c3ece2608fd0123c78b5905eac3d22523027ae38500f117472135aafb9c09b83e6c9ee8a5358fc109c92eb2292118d672bd338b3ddbafb2e0f97c6f063e0c"
var orgPrivateKey = "7b22707269765f73657269616c697a65223a223451444d4156526a74496d6674734231626941494261446562542b4b6737374173492f632b7a52554744733d222c22707269765f74797065223a32317d"
var orgCert = `{"public_key_hash_algorithm":21,"public_key_byte":"BOV8Ps4mCP0BI8eLWQXqw9IlIwJ644UA8RdHITWq+5wJuD5snuilNY/BCckusikhGNZyvTOLPduvsuD5fG8GPgw=","publickey":null,"cert_type":2,"extensions":100,"not_before":1590481638,"not_after":1587889638,"cert_hash":"Ha472yKk1K4IzZy2OIX3LRoACEHBvAWgz4Mq2lAL99I=","signature":"HTM2m8T/SXY/76G+F5ha26O4fZFtP4UrgjZkJs0dvUgYGct95CAA5fVFvUAXcuujcLmGiUtC9I/LUthCzMALzQ==","signature_algorithm":16}`

var channelPublicKey = "048d9056afe7afb7f0e9626bec6629832641f3b69a5b211f23a43b59075bdc97c1687f180e09dc01e994b161c046f46e35179bf76f66443d0ebb6f099feb9bf009"
var channelPrivateKey = "7b22707269765f73657269616c697a65223a222f686736796e6e4c366858715357784530456479746f743939526a4e69563835793374585a37464e62616f3d222c22707269765f74797065223a32317d"
var channelCert = `{"public_key_hash_algorithm":21,"public_key_byte":"BI2QVq/nr7fw6WJr7GYpgyZB87aaWyEfI6Q7WQdb3JfBaH8YDgncAemUsWHARvRuNReb929mRD0Ou28Jn+ub8Ak=","publickey":null,"cert_type":2,"extensions":100,"not_before":1590481745,"not_after":1587889745,"cert_hash":"HcVbsa7IyEy28DbuUTSbyG7TqxM7CXd3IQwlD+1QR/A=","signature":"/H74hQgN6hEL7c2+p2hfCgmzKw/uXxVtsMWf5xtxH+FgRAyaz2nLr1pdmcszZRJmEGTeBenR+bU0rtTmog7b6w==","signature_algorithm":16}`

var merchantPublicKey = "041922e1019b52daa86246b1a330efc2e7308f9019000bda3103bd863a05776ff3d6d274b368778bbbfccfcb07179dae39ae55cb79aba3da14ecdbb20bb9239bf7"
var merchantPrivateKey = "7b22707269765f73657269616c697a65223a226e68724c34536c454d6b7431356c2b385651576b466d6d724c516333674b364a62527565757a39594451413d222c22707269765f74797065223a32317d"
var merchantCert = `{"public_key_hash_algorithm":21,"public_key_byte":"BBki4QGbUtqoYkaxozDvwucwj5AZAAvaMQO9hjoFd2/z1tJ0s2h3i7v8z8sHF52uOa5Vy3mro9oU7NuyC7kjm/c=","publickey":null,"cert_type":3,"extensions":100,"not_before":1590482496,"not_after":1587890496,"cert_hash":"C/L+z0ZZPnbPX8mkab88feMYNlSPRx9s5Xsitls7zoU=","signature":"5o/BpTdBedJea7w/yYpIjuj1OJa/g5hh5c2oAYDN0pmOQlHw/nftJTERMpl8GqwU3sEXh5My3tFmuI6WbLyuXA==","signature_algorithm":16}`

func TestCreateCoupons(t *testing.T) {

	cc := new(CPSChainCode)
	stub := shim.NewMockStub("CPSCC",cc)
	stub.MockInit("init",nil)
	fmt.Println()
	//fmt.Println("========================================invoke certManagement createOrg============================================")
	//fmt.Println()
	//fmt.Println()
	//responseByPutschema := stub.MockInvoke("invoke1",[][]byte{[]byte("certManagement/createOrg"),[]byte(orgCert),[]byte(orgPublicKey)})
	//fmt.Printf("Invoke status %d,message %s and payload %s\n",responseByPutschema.Status,responseByPutschema.Message,string(responseByPutschema.Payload))
	//
	//
	//fmt.Println("========================================invoke certManagement createDitch============================================")
	//fmt.Println()
	//fmt.Println()
	//responseByPutschema = stub.MockInvoke("invoke1",[][]byte{[]byte("certManagement/createDitch"),[]byte(orgPublicKey),[]byte(channelCert)})
	//fmt.Printf("Invoke status %d,message %s and payload %s\n",responseByPutschema.Status,responseByPutschema.Message,string(responseByPutschema.Payload))
	//
	//fmt.Println("========================================invoke certManagement createMerchantsApi============================================")
	//fmt.Println()
	//fmt.Println()
	//responseByPutschema = stub.MockInvoke("invoke1",[][]byte{[]byte("certManagement/createMerchants"),[]byte(orgPublicKey),[]byte(merchantCert)})
	//fmt.Printf("Invoke status %d,message %s and payload %s\n",responseByPutschema.Status,responseByPutschema.Message,string(responseByPutschema.Payload))


	//fmt.Println("========================================invoke createTx createCoupons============================================")
	//fmt.Println()
	//fmt.Println()
	//responseByPutschema := stub.MockInvoke("invoke1",[][]byte{[]byte("createTx/updateMertUtxo"), []byte(orgPublicKey),[]byte(createCouponsData),[]byte(createCouponsDataSign)})
	//fmt.Printf("Invoke status %d,message %s and payload %s\n",responseByPutschema.Status,responseByPutschema.Message,string(responseByPutschema.Payload))


	//fmt.Println("========================================invoke createTx disCoupon============================================")
	//fmt.Println()
	//fmt.Println()
	//responseByPutschema = stub.MockInvoke("invoke1",[][]byte{[]byte("createTx/disCoupon"),[]byte(orgPublicKey),[]byte(disCouponsData),[]byte(disCouponsDataSign)})
	//fmt.Printf("Invoke status %d,message %s and payload %s\n",responseByPutschema.Status,responseByPutschema.Message,string(responseByPutschema.Payload))
	//
	//fmt.Println("========================================invoke createTx userApplyCoupon============================================")
	//fmt.Println()
	//fmt.Println()
	//responseByPutschema = stub.MockInvoke("invoke1",[][]byte{[]byte("createTx/userApplyCoupon"),[]byte(channelPublicKey),[]byte(applyCouponsData),[]byte(applyCouponsDataSign)})
	//fmt.Printf("Invoke status %d,message %s and payload %s\n",responseByPutschema.Status,responseByPutschema.Message,string(responseByPutschema.Payload))
	//
	//fmt.Println("========================================invoke createTx useCoupon============================================")
	//fmt.Println()
	//fmt.Println()
	//responseByPutschema = stub.MockInvoke("invoke1",[][]byte{[]byte("createTx/useCoupon"),[]byte(merchantPublicKey),[]byte(useCouponsData),[]byte(useCouponsDataSign)})
	//fmt.Printf("Invoke status %d,message %s and payload %s\n",responseByPutschema.Status,responseByPutschema.Message,string(responseByPutschema.Payload))
	//
	//
	//fmt.Println("========================================query getCoupons============================================")
	//fmt.Println()
	//fmt.Println()
	//responseByPutschema = stub.MockInvoke("invoke1",[][]byte{[]byte("getCoupons"),[]byte(orgPublicKey),[]byte(getCouponsData),[]byte(useCouponsDataSign)})
	//fmt.Printf("Invoke status %d,message %s and payload %s\n",responseByPutschema.Status,responseByPutschema.Message,string(responseByPutschema.Payload))
	//
	//fmt.Println("========================================query getCouponsByAddress============================================")
	//fmt.Println()
	//fmt.Println()
	//responseByPutschema = stub.MockInvoke("invoke1",[][]byte{[]byte("getCouponsByAddress"),[]byte(orgPublicKey),[]byte(getCouponsByAddress),[]byte(useCouponsDataSign)})
	//fmt.Printf("Invoke status %d,message %s and payload %s\n",responseByPutschema.Status,responseByPutschema.Message,string(responseByPutschema.Payload))
	//
	//fmt.Println("========================================query subsidiesApi============================================")
	//fmt.Println()
	//fmt.Println()
	//responseByPutschema = stub.MockInvoke("invoke1",[][]byte{[]byte("subsidies"),[]byte(orgPublicKey),[]byte(subsidiesData),[]byte(useCouponsDataSign)})
	//fmt.Printf("Invoke status %d,message %s and payload %s\n",responseByPutschema.Status,responseByPutschema.Message,string(responseByPutschema.Payload))



}

var orgUser = `{"oid":"1","name":"","cert":"{\"public_key_hash_algorithm\":21,\"public_key_byte\":\"BOV8Ps4mCP0BI8eLWQXqw9IlIwJ644UA8RdHITWq+5wJuD5snuilNY/BCckusikhGNZyvTOLPduvsuD5fG8GPgw=\",\"publickey\":null,\"cert_type\":1,\"extensions\":100,\"not_before\":1590481638,\"not_after\":1587889638,\"cert_hash\":\"Ha472yKk1K4IzZy2OIX3LRoACEHBvAWgz4Mq2lAL99I=\",\"signature\":\"HTM2m8T/SXY/76G+F5ha26O4fZFtP4UrgjZkJs0dvUgYGct95CAA5fVFvUAXcuujcLmGiUtC9I/LUthCzMALzQ==\",\"signature_algorithm\":16}","create_time":"0001-01-01T00:00:00Z"}`
var ditchUser = `{"did":"11","name":"","cert":"{\"public_key_hash_algorithm\":21,\"public_key_byte\":\"BI2QVq/nr7fw6WJr7GYpgyZB87aaWyEfI6Q7WQdb3JfBaH8YDgncAemUsWHARvRuNReb929mRD0Ou28Jn+ub8Ak=\",\"publickey\":null,\"cert_type\":2,\"extensions\":100,\"not_before\":1590481745,\"not_after\":1587889745,\"cert_hash\":\"HcVbsa7IyEy28DbuUTSbyG7TqxM7CXd3IQwlD+1QR/A=\",\"signature\":\"/H74hQgN6hEL7c2+p2hfCgmzKw/uXxVtsMWf5xtxH+FgRAyaz2nLr1pdmcszZRJmEGTeBenR+bU0rtTmog7b6w==\",\"signature_algorithm\":16}","create_time":"0001-01-01T00:00:00Z"}`
var merUser =`{"mid":"111","type":"","name":"","address":"","cert":"{\"public_key_hash_algorithm\":21,\"public_key_byte\":\"BBki4QGbUtqoYkaxozDvwucwj5AZAAvaMQO9hjoFd2/z1tJ0s2h3i7v8z8sHF52uOa5Vy3mro9oU7NuyC7kjm/c=\",\"publickey\":null,\"cert_type\":3,\"extensions\":100,\"not_before\":1590482496,\"not_after\":1587890496,\"cert_hash\":\"C/L+z0ZZPnbPX8mkab88feMYNlSPRx9s5Xsitls7zoU=\",\"signature\":\"5o/BpTdBedJea7w/yYpIjuj1OJa/g5hh5c2oAYDN0pmOQlHw/nftJTERMpl8GqwU3sEXh5My3tFmuI6WbLyuXA==\",\"signature_algorithm\":16}","create_time":"0001-01-01T00:00:00Z"}`
func TestCreateUser(t *testing.T){
	org := &Orgnazation{}
	org.Cert = orgCert
	org.Oid = "1"
	orgByte,err := json.Marshal(org)
	if err!=nil{
		t.Error(err)
	}
	fmt.Println(string(orgByte))
	ditch := &Ditch{}
	ditch.Cert = channelCert
	ditch.Did = "11"
	ditchByte,err := json.Marshal(ditch)
	if err!=nil{
		t.Error(err)
	}
	fmt.Println(string(ditchByte))
	mer := &Merchant{}
	mer.Cert = merchantCert
	mer.Mid = "111"
	merByte,err := json.Marshal(mer)
	if err!=nil{
		t.Error(err)
	}
	fmt.Println(string(merByte))
}
func TestRouterest(t *testing.T) {
	//coupon := &Coupons{
	//	CoupId:"0001",
	//	CoupType:"XJQ",
	//	CoupValid:"2017-01-13 23:59:59",
	//	CoupAvailableTime:"券可用时间段",
	//	CoupDescription:"券描述",
	//	CoupQuantity:1000000,
	//	CoupAmount:10.00,
	//	CoupDiscount:0.5,
	//	CoupTotalAmount:10000000.00,
	//	FloorAmount:10.00,
	//	Extensions:nil,
	//}
	type Test struct {
		UAddress []string `json:"uAddress"`
		Mid string `json:"mid"`
	}
	test := &Test{
		UAddress:[]string{"qqqqq","wwwwww","eeeeee"},
		Mid:"0001",
	}
	couponByte,err  := json.Marshal(test)
	if err!=nil{
		fmt.Println("err",err)
	}
	fmt.Println("couponByte",couponByte)
	tx:= Trans{
		Value:string(couponByte),
	}
	txByte,err  := json.Marshal(tx)
	if err!=nil{
		fmt.Println("err",err)
	}
	fmt.Println(string(txByte))

}

func TestParse(t *testing.T){
	_,err := ParseCertificate([]byte(channelCert))
	if err!=nil{
		t.Error(err)
	}
}

var userPubHex = `7b227075625f73657269616c697a65223a2242484f2f74413243544464614c46575054632b326e51577a504f6e663134466e79776b55694c6e44556f38466f4d446b453048724341355166736f76766b6a374e35474d5076644b64736d4273646c2f2f4b4643356b4d3d222c227075625f74797065223a32317d`
var usePrivHex = `7b22707269765f73657269616c697a65223a2277526e35323350712f547064675673437a6349384956386e41446453637a3861514f4e2b4d51676a4b66413d222c22707269765f74797065223a32317d`
func TestCreateTx(t *testing.T){
	//coupons:= &Coupons{
	//	CoupId:"c1",
	//	IssueOrgId:"1",
	//	CoupQuantity:100,
	//	UseMerchats:[]string{"111"},
	//}
	//couponsByte,err := json.Marshal(coupons)
	//if err !=nil{
	//	t.Error(err)
	//}
	//disvalue:= make( map[string]interface{})
	//disvalue["did"] = "11"
	//disvalue["amount"] = 99
	//disByte,err := json.Marshal(disvalue)
	//if err !=nil{
	//	t.Error(err)
	//}
  //user:= UserInfo{
  //
  //}
	//userByte,err := json.Marshal(user)
	//if err !=nil{
	//	t.Error(err)
	//}
	//tx := Trans{
	//	Value:string(userByte),
	//	From:"utxo2",
	//To:"utxo3",
	//ToPub:userPubHex,
	//}
	usevalue:= make( map[string]interface{})
	usevalue["privHex"] = usePrivHex
	useByte,err := json.Marshal(usevalue)
	if err !=nil{
		t.Error(err)
	}
	tx := Trans{
			Value:string(useByte),
			From:"utxo3",
		To:"utxo4",
		ToPub:userPubHex,
		}
	txByte,err := json.Marshal(tx)
	if err !=nil{
		t.Error(err)
	}
	fmt.Println(hex.EncodeToString(txByte))
	fmt.Println(string(txByte))
	message := &Message{
		OwnId:"1",
		Data:string(txByte),
		Sign:"c384f2bc27a9abc87b07ce798fd4a65323aab9ddbd4aee8b379c1a987e6cf272b9becc5fb4bcd2f3d8495fe715ed4c263c6b4c5ce68067d39922df12fd075fc9",
	}
   messageByte,err := json.Marshal(message)
	if err !=nil{
		t.Error(err)
	}
	fmt.Println(string(messageByte))
}

var createCouponsSign =`e99c297f03c1f3b5bbf1602dc15ff61bb05fb2617abc1e29f28f9d59c8445e39d19d3897827a85567032a7e0e711e20c6092e6e733a3a886de87ab3bf6b9e671`
var createCouponsSign1 =`5af9620fdd58f5fc43833b180bbc912c29f8ea8c2a8f3a52f5ae807f098545d592ea4b2a003845edc9a6af8c6b58cf0d6d55bc8a705ec7a464056287f3c75c62`
var createCouponsDate1 =`{"value":"{\"coup_id\":\"c11\",\"issue_org_id\":\"1\",\"coup_type\":\"\",\"coup_valid\":\"\",\"coup_available_time\":\"\",\"coup_description\":\"\",\"coup_quantity\":100,\"coup_amount\":0,\"coup_discount\":0,\"coup_total_amount\":0,\"floor_amount\":0,\"use_merchats\":[\"111\"],\"use_merchants_type\":null,\"extensions\":null}","fromAddress":"","toAddress":"utxo1","toPublicKey":"1"}`
var createCouponsDate =`{"value":"{\"coup_id\":\"c1\",\"issue_org_id\":\"1\",\"coup_type\":\"\",\"coup_valid\":\"\",\"coup_available_time\":\"\",\"coup_description\":\"\",\"coup_quantity\":100,\"coup_amount\":0,\"coup_discount\":0,\"coup_total_amount\":0,\"floor_amount\":0,\"use_merchats\":[\"111\"],\"use_merchants_type\":null,\"extensions\":null}","fromAddress":"","toAddress":"utxo1","toPublicKey":"1"}`

var disCouponsSign = `54063e3edce3905d44312a7e4038d9a06f819eae0991d04a4b8e944c721d716eaaab47befba449c2bf4e4634847daad3f2c4ed49ae80e50b4f051a1a8675cb99`
var disCouponsSign1 = `54063e3edce3905d44312a7e4038d9a06f819eae0991d04a4b8e944c721d716eaaab47befba449c2bf4e4634847daad3f2c4ed49ae80e50b4f051a1a8675cb99`
var disCouponsDate = `{"value":"{\"amount\":99,\"did\":\"11\"}","fromAddress":"utxo1","toAddress":"utxo2","toPublicKey":"11"}`

var ApplyCouponsSign = `384680b931d61d74f92dce95407f917455845c0c8d26826b87830d5b2851b5abf54e145f18e7c7e0f1c0c4febcaf059c6ae24a48953ea9bf1d192080e8916693`
var ApplyCouponsDate = `{"value":"{\"uid\":\"\",\"name\":\"\",\"number\":\"\",\"phone\":\"\",\"create_time\":\"0001-01-01T00:00:00Z\"}","fromAddress":"utxo2","toAddress":"utxo3","toPublicKey":"7b227075625f73657269616c697a65223a2242484f2f74413243544464614c46575054632b326e51577a504f6e663134466e79776b55694c6e44556f38466f4d446b453048724341355166736f76766b6a374e35474d5076644b64736d4273646c2f2f4b4643356b4d3d222c227075625f74797065223a32317d"}`

var useCouponsSign = `64676e919d52bf33f79a1854d8f4b432b18d438941b4bc6d261293bee8f64a53bcce6dcd7b639d3dfb6cb4198b4af7f028aabdbdd321fc6b4ad458dc6b48c852`
var useCouponsDate = `{"value":"{\"orderSign\":\"cb272bf42428ae99322c924b83fc24dada62b2bd063dbe570e56d8fddfa9d10a6437c3ef2e4b8c187234729bbe4af0371ec774e1c69d2002a73dae62310204af\",\"order\":\"订单信息\",\"algorithm\":1}","fromAddress":"utxo3","toAddress":"utxo4"}`

var getCouponsSign = `ae4ed3d14343109d8c427eb472a1ea6d8ceb30d5262a6fe9fdf53ffaedee36a908c20e1756d137c51ada112924dc69e2c344e3bedad21bfb2ba4bbf115617ab1`
var getCouponsDate = `{"value":"{\"coup_id\":\"c1\"}"}`

var getUtxoSign = `d384e0d41d3264210e10471ba9d83a1608ead270382863151e180be87740cabe03cf42d3ee484b2c29127ec817fb0c9471df3ac24471a0fc970dcbea27f1775e`
var getUtxoInfo = `{"fromAddress":"utxo3"}`

var getUtxoSign1 = `232d69a60be346f65b011e9dfb0e98a211eb9592f90beaaf3d8e3c25897cf1c4f3b15d36e67d10d5fc3cdf5a5c831266ef3ba703ee7a4b11c4b87711b20e9678`
var getUtxoInfo1 = `{"fromAddress":"utxo2"}`

func TestCouponsFlow(t *testing.T){
	cc := new(CPSChainCode)
	stub := shim.NewMockStub("CPSCC",cc)
	stub.MockInit("init",nil)
	fmt.Println()
	fmt.Println("========================================invoke certManagement createOrg============================================")
	fmt.Println()
	fmt.Println()
	responseByPutschema := stub.MockInvoke("invoke1",[][]byte{[]byte("certManagement/createOrg"),[]byte(orgUser)})
	fmt.Printf("Invoke status %d,message %s and payload %s\n",responseByPutschema.Status,responseByPutschema.Message,string(responseByPutschema.Payload))


	fmt.Println("========================================invoke certManagement createDitch============================================")
	fmt.Println()
	fmt.Println()
	responseByPutschema = stub.MockInvoke("invoke1",[][]byte{[]byte("certManagement/createDitch"),[]byte("1"),[]byte(ditchUser)})
	fmt.Printf("Invoke status %d,message %s and payload %s\n",responseByPutschema.Status,responseByPutschema.Message,string(responseByPutschema.Payload))

	fmt.Println("========================================invoke certManagement createMerchantsApi============================================")
	fmt.Println()
	fmt.Println()
	responseByPutschema = stub.MockInvoke("invoke1",[][]byte{[]byte("certManagement/createMerchants"),[]byte("1"),[]byte(merUser)})
	fmt.Printf("Invoke status %d,message %s and payload %s\n",responseByPutschema.Status,responseByPutschema.Message,string(responseByPutschema.Payload))
	fmt.Println("========================================invoke createTx createCoupons============================================")
	fmt.Println()
	fmt.Println()
	responseByPutschema = stub.MockInvoke("invoke1",[][]byte{[]byte("createTx/createCoupons"), []byte("1"),[]byte(createCouponsDate),[]byte(createCouponsSign)})
	fmt.Printf("Invoke status %d,message %s and payload %s\n",responseByPutschema.Status,responseByPutschema.Message,string(responseByPutschema.Payload))
	fmt.Println("========================================测试错误的私钥签名============================================")
	fmt.Println()
	fmt.Println()
	responseByPutschema = stub.MockInvoke("invoke1",[][]byte{[]byte("createTx/createCoupons"), []byte("1"),[]byte(createCouponsDate1),[]byte(createCouponsSign1)})
	fmt.Printf("Invoke status %d,message %s and payload %s\n",responseByPutschema.Status,responseByPutschema.Message,string(responseByPutschema.Payload))
	fmt.Println("========================================测试原始数据被修改============================================")
	fmt.Println()
	fmt.Println()
	responseByPutschema = stub.MockInvoke("invoke1",[][]byte{[]byte("createTx/createCoupons"), []byte("1"),[]byte(createCouponsDate1),[]byte(createCouponsSign)})
	fmt.Printf("Invoke status %d,message %s and payload %s\n",responseByPutschema.Status,responseByPutschema.Message,string(responseByPutschema.Payload))
	fmt.Println("========================================invoke createTx disCoupon============================================")
	fmt.Println()
	fmt.Println()
	responseByPutschema = stub.MockInvoke("invoke1",[][]byte{[]byte("createTx/disCoupon"),[]byte("1"),[]byte(disCouponsDate),[]byte(disCouponsSign)})
	fmt.Printf("Invoke status %d,message %s and payload %s\n",responseByPutschema.Status,responseByPutschema.Message,string(responseByPutschema.Payload))
	fmt.Println("========================================invoke createTx userApplyCoupon============================================")
	fmt.Println()
	fmt.Println()
	responseByPutschema = stub.MockInvoke("invoke1",[][]byte{[]byte("createTx/userApplyCoupon"),[]byte("11"),[]byte(ApplyCouponsDate),[]byte(ApplyCouponsSign)})
	fmt.Printf("Invoke status %d,message %s and payload %s\n",responseByPutschema.Status,responseByPutschema.Message,string(responseByPutschema.Payload))
	fmt.Println("========================================invoke createTx useCoupon============================================")
	fmt.Println()
	fmt.Println()
	responseByPutschema = stub.MockInvoke("invoke1",[][]byte{[]byte("createTx/useCoupon"),[]byte("111"),[]byte(useCouponsDate),[]byte(useCouponsSign)})
	fmt.Printf("Invoke status %d,message %s and payload %s\n",responseByPutschema.Status,responseByPutschema.Message,string(responseByPutschema.Payload))

	fmt.Println("========================================query getCoupons============================================")
	fmt.Println()
	fmt.Println()
	responseByPutschema = stub.MockInvoke("invoke1",[][]byte{[]byte("getCoupons"),[]byte("1"),[]byte(getCouponsDate),[]byte(getCouponsSign)})
	fmt.Printf("Invoke status %d,message %s and payload %s\n",responseByPutschema.Status,responseByPutschema.Message,string(responseByPutschema.Payload))

	fmt.Println("========================================query getCouponsByAddress============================================")
	fmt.Println()
	fmt.Println()
	responseByPutschema = stub.MockInvoke("invoke1",[][]byte{[]byte("getCouponsByAddress"),[]byte("111"),[]byte(getUtxoInfo),[]byte(getUtxoSign)})
	fmt.Printf("Invoke status %d,message %s and payload %s\n",responseByPutschema.Status,responseByPutschema.Message,string(responseByPutschema.Payload))

	fmt.Println("========================================测试查询未使用的UTXO============================================")
	fmt.Println()
	fmt.Println()
	responseByPutschema = stub.MockInvoke("invoke1",[][]byte{[]byte("getCouponsByAddress"),[]byte("111"),[]byte(getUtxoInfo1),[]byte(getUtxoSign1)})
	fmt.Printf("Invoke status %d,message %s and payload %s\n",responseByPutschema.Status,responseByPutschema.Message,string(responseByPutschema.Payload))
}
